/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.mapped.MappedFile;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

final class MappedSequentialFile
implements SequentialFile {
    private final File directory;
    private final IOCriticalErrorListener criticalErrorListener;
    private final MappedSequentialFileFactory factory;
    private File file;
    private File absoluteFile;
    private String fileName;
    private MappedFile mappedFile;
    private int capacity;

    MappedSequentialFile(MappedSequentialFileFactory factory, File directory, File file, int capacity, IOCriticalErrorListener criticalErrorListener) {
        this.factory = factory;
        this.directory = directory;
        this.file = file;
        this.absoluteFile = null;
        this.fileName = null;
        this.capacity = capacity;
        this.mappedFile = null;
        this.criticalErrorListener = criticalErrorListener;
    }

    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    public int capacity() {
        return this.capacity;
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("File not opened!");
        }
    }

    private void checkIsOpen(IOCallback callback) {
        if (!this.isOpen()) {
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "File not opened");
        }
    }

    private void checkIsNotOpen() {
        if (this.isOpen()) {
            throw new IllegalStateException("File opened!");
        }
    }

    @Override
    public boolean isOpen() {
        return this.mappedFile != null;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void open() throws IOException {
        if (this.mappedFile == null) {
            this.mappedFile = MappedFile.of(this.file, 0, this.capacity);
        }
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws IOException {
        this.open();
    }

    @Override
    public boolean fits(int size) {
        this.checkIsOpen();
        long newPosition = this.mappedFile.position() + size;
        boolean hasRemaining = newPosition <= this.mappedFile.length();
        return hasRemaining;
    }

    @Override
    public int calculateBlockStart(int position) {
        return position;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    @Override
    public void fill(int size) throws IOException {
        this.checkIsOpen();
        this.mappedFile.zeros(this.mappedFile.position(), size);
        if (this.factory.isDatasync()) {
            this.mappedFile.force();
        }
    }

    @Override
    public void delete() {
        this.close();
        if (this.file.exists() && !this.file.delete()) {
            ActiveMQJournalLogger.LOGGER.errorDeletingFile(this);
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws IOException {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        this.checkIsOpen(callback);
        try {
            ByteBuf byteBuf = bytes.byteBuf();
            int writerIndex = byteBuf.writerIndex();
            int readerIndex = byteBuf.readerIndex();
            int readableBytes = writerIndex - readerIndex;
            if (readableBytes > 0) {
                this.mappedFile.write(byteBuf, readerIndex, readableBytes);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync) throws IOException {
        this.checkIsOpen();
        ByteBuf byteBuf = bytes.byteBuf();
        int writerIndex = byteBuf.writerIndex();
        int readerIndex = byteBuf.readerIndex();
        int readableBytes = writerIndex - readerIndex;
        if (readableBytes > 0) {
            this.mappedFile.write(byteBuf, readerIndex, readableBytes);
            if (this.factory.isDatasync() && sync) {
                this.mappedFile.force();
            }
        }
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws IOException {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        this.checkIsOpen(callback);
        try {
            this.mappedFile.write(bytes);
            if (this.factory.isDatasync() && sync) {
                this.mappedFile.force();
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync) throws IOException {
        this.checkIsOpen();
        this.mappedFile.write(bytes);
        if (this.factory.isDatasync() && sync) {
            this.mappedFile.force();
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        try {
            if (callback == null) {
                throw new NullPointerException("callback parameter need to be set");
            }
            this.checkIsOpen(callback);
            int position = bytes.position();
            int limit = bytes.limit();
            int remaining = limit - position;
            if (remaining > 0) {
                this.mappedFile.write(bytes, position, remaining);
                int newPosition = position + remaining;
                bytes.position(newPosition);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
            callback.done();
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.factory.releaseBuffer(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws IOException {
        try {
            this.checkIsOpen();
            int position = bytes.position();
            int limit = bytes.limit();
            int remaining = limit - position;
            if (remaining > 0) {
                this.mappedFile.write(bytes, position, remaining);
                int newPosition = position + remaining;
                bytes.position(newPosition);
                if (this.factory.isDatasync() && sync) {
                    this.mappedFile.force();
                }
            }
        }
        finally {
            this.factory.releaseBuffer(bytes);
        }
    }

    @Override
    public int read(ByteBuffer bytes, IOCallback callback) throws IOException {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        this.checkIsOpen(callback);
        try {
            int position = bytes.position();
            int limit = bytes.limit();
            int remaining = limit - position;
            if (remaining > 0) {
                int bytesRead = this.mappedFile.read(bytes, position, remaining);
                int newPosition = position + bytesRead;
                bytes.position(newPosition);
                bytes.flip();
                callback.done();
                return bytesRead;
            }
            callback.done();
            return 0;
        }
        catch (IOException e) {
            if (this.criticalErrorListener != null) {
                this.criticalErrorListener.onIOException((Throwable)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            throw e;
        }
    }

    @Override
    public int read(ByteBuffer bytes) throws IOException {
        this.checkIsOpen();
        int position = bytes.position();
        int limit = bytes.limit();
        int remaining = limit - position;
        if (remaining > 0) {
            int bytesRead = this.mappedFile.read(bytes, position, remaining);
            int newPosition = position + bytesRead;
            bytes.position(newPosition);
            bytes.flip();
            return bytesRead;
        }
        return 0;
    }

    @Override
    public void position(long pos) {
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("pos must be < 2147483647");
        }
        this.checkIsOpen();
        this.mappedFile.position((int)pos);
    }

    @Override
    public long position() {
        this.checkIsOpen();
        return this.mappedFile.position();
    }

    @Override
    public void close() {
        if (this.mappedFile != null) {
            this.mappedFile.close();
            this.mappedFile = null;
        }
    }

    @Override
    public void sync() throws IOException {
        this.checkIsOpen();
        if (this.factory.isDatasync()) {
            this.mappedFile.force();
        }
    }

    @Override
    public long size() {
        if (this.mappedFile != null) {
            return this.mappedFile.length();
        }
        return this.file.length();
    }

    @Override
    public void renameTo(String newFileName) throws Exception {
        try {
            this.close();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
            throw e;
        }
        if (this.fileName == null) {
            this.fileName = this.file.getName();
        }
        if (!this.fileName.contentEquals(newFileName)) {
            File newFile = new File(this.directory, newFileName);
            if (!this.file.renameTo(newFile)) {
                throw ActiveMQJournalBundle.BUNDLE.ioRenameFileError(this.file.getName(), newFileName);
            }
            this.file = newFile;
            this.fileName = newFileName;
            this.absoluteFile = null;
        }
    }

    @Override
    public MappedSequentialFile cloneFile() {
        this.checkIsNotOpen();
        return new MappedSequentialFile(this.factory, this.directory, this.file, this.capacity, this.criticalErrorListener);
    }

    @Override
    public void copyTo(SequentialFile dstFile) throws IOException {
        block74: {
            this.checkIsNotOpen();
            if (dstFile.isOpen()) {
                throw new IllegalArgumentException("dstFile must be closed too");
            }
            try (RandomAccessFile src = new RandomAccessFile(this.file, "rw");
                 FileChannel srcChannel = src.getChannel();
                 FileLock srcLock = srcChannel.lock();){
                long readableBytes = srcChannel.size();
                if (readableBytes <= 0L) break block74;
                try (RandomAccessFile dst = new RandomAccessFile(dstFile.getJavaFile(), "rw");
                     FileChannel dstChannel = dst.getChannel();
                     FileLock dstLock = dstChannel.lock();){
                    long oldLength = dst.length();
                    long newLength = oldLength + readableBytes;
                    dst.setLength(newLength);
                    long transferred = dstChannel.transferFrom(srcChannel, oldLength, readableBytes);
                    if (transferred != readableBytes) {
                        dstChannel.truncate(oldLength);
                        throw new IOException("copied less then expected");
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public void setTimedBuffer(TimedBuffer buffer) {
        throw new UnsupportedOperationException("the timed buffer is not currently supported");
    }

    @Override
    public File getJavaFile() {
        if (this.absoluteFile == null) {
            this.absoluteFile = this.file.getAbsoluteFile();
        }
        return this.absoluteFile;
    }
}

