/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;

public class SessionReceiveMessage
extends MessagePacket {
    protected long consumerID;
    protected int deliveryCount;

    public SessionReceiveMessage(long consumerID, ICoreMessage message, int deliveryCount) {
        super((byte)75, message);
        this.consumerID = consumerID;
        this.deliveryCount = deliveryCount;
    }

    public SessionReceiveMessage(CoreMessage message) {
        super((byte)75, message);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public int expectedEncodeSize() {
        return this.message.getEncodeSize() + 13 + 8 + 4;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        this.message.sendBuffer(buffer.byteBuf(), this.deliveryCount);
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.receiveMessage(this.copyMessageBuffer(buffer.byteBuf(), 12));
        buffer.readerIndex(buffer.capacity() - 8 - 4);
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
    }

    protected void receiveMessage(ByteBuf buffer) {
        this.message.receiveBuffer(buffer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + this.deliveryCount;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", consumerID=" + this.consumerID);
        buff.append(", deliveryCount=" + this.deliveryCount);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionReceiveMessage)) {
            return false;
        }
        SessionReceiveMessage other = (SessionReceiveMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        return this.deliveryCount == other.deliveryCount;
    }
}

