/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.protocol.ClientPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.Ping;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQFrameDecoder2;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.spi.core.remoting.TopologyResponseHandler;
import org.apache.activemq.artemis.utils.VersionLoader;

public class ActiveMQClientProtocolManager
implements ClientProtocolManager {
    private static final Logger logger = Logger.getLogger(ActiveMQClientProtocolManager.class);
    private static final String handshake = "ARTEMIS";
    private final int versionID = VersionLoader.getVersion().getIncrementingVersion();
    private ClientSessionFactoryInternal factoryInternal;
    private final Object inCreateSessionGuard = new Object();
    private boolean inCreateSession;
    private CountDownLatch inCreateSessionLatch;
    protected volatile RemotingConnectionImpl connection;
    protected TopologyResponseHandler topologyResponseHandler;
    private volatile boolean alive = true;
    private final CountDownLatch waitLatch = new CountDownLatch(1);

    @Override
    public String getName() {
        return "CORE";
    }

    @Override
    public void setSessionFactory(ClientSessionFactory factory) {
        this.factoryInternal = (ClientSessionFactoryInternal)factory;
    }

    @Override
    public ClientSessionFactory getSessionFactory() {
        return this.factoryInternal;
    }

    @Override
    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("activemq-decoder", (io.netty.channel.ChannelHandler)new ActiveMQFrameDecoder2());
    }

    @Override
    public boolean waitOnLatch(long milliseconds) throws InterruptedException {
        return this.waitLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public Channel getChannel0() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
    }

    @Override
    public RemotingConnection getCurrentConnection() {
        return this.connection;
    }

    public Channel getChannel1() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getChannel(1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Lock lockSessionCreation() {
        try {
            Lock localFailoverLock = this.factoryInternal.lockFailover();
            try {
                if (this.connection == null) {
                    Lock lock = null;
                    return lock;
                }
                Lock lock = this.getChannel1().getLock();
                while (this.isAlive() && !lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
                }
                Lock lock2 = lock;
                return lock2;
            }
            finally {
                localFailoverLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.alive = false;
        Object object = this.inCreateSessionGuard;
        synchronized (object) {
            if (this.inCreateSessionLatch != null) {
                this.inCreateSessionLatch.countDown();
            }
        }
        Channel channel1 = this.getChannel1();
        if (channel1 != null) {
            channel1.returnBlocking();
        }
        this.waitLatch.countDown();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void ping(long connectionTTL) {
        Channel channel = this.connection.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
        Ping ping = new Ping(connectionTTL);
        channel.send(ping);
        this.connection.flush();
    }

    @Override
    public void sendSubscribeTopology(boolean isServer) {
        this.getChannel0().send(new SubscribeClusterTopologyUpdatesMessageV2(isServer, VersionLoader.getVersion().getIncrementingVersion()));
    }

    @Override
    public SessionContext createSessionContext(String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize) throws ActiveMQException {
        for (Version clientVersion : VersionLoader.getClientVersions()) {
            try {
                return this.createSessionContext(clientVersion, name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, minLargeMessageSize, confirmationWindowSize);
            }
            catch (ActiveMQException e) {
                if (e.getType() == ActiveMQExceptionType.INCOMPATIBLE_CLIENT_SERVER_VERSIONS) continue;
                throw e;
            }
        }
        this.connection.destroy();
        throw new ActiveMQException(ActiveMQExceptionType.INCOMPATIBLE_CLIENT_SERVER_VERSIONS);
    }

    /*
     * Exception decompiling
     */
    public SessionContext createSessionContext(Version clientVersion, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize) throws ActiveMQException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Packet newCreateSessionPacket(Version clientVersion, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, long sessionChannelID) {
        return new CreateSessionMessage(name, sessionChannelID, clientVersion.getIncrementingVersion(), username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, confirmationWindowSize, null);
    }

    protected SessionContext newSessionContext(String name, int confirmationWindowSize, Channel sessionChannel, CreateSessionResponseMessage response) {
        return new ActiveMQSessionContext(name, this.connection, sessionChannel, response.getServerVersion(), confirmationWindowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupBeforeFailover(ActiveMQException cause) {
        CountDownLatch exitLockLatch;
        boolean needToInterrupt;
        Lock lock = this.lockSessionCreation();
        if (lock == null) {
            return false;
        }
        try {
            Object object = this.inCreateSessionGuard;
            synchronized (object) {
                needToInterrupt = this.inCreateSession;
                exitLockLatch = this.inCreateSessionLatch;
            }
        }
        finally {
            lock.unlock();
        }
        if (needToInterrupt) {
            this.forceReturnChannel1(cause);
            while (this.inCreateSession && this.isAlive()) {
                try {
                    if (exitLockLatch == null) continue;
                    exitLockLatch.await(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e1) {
                    throw new ActiveMQInterruptedException(e1);
                }
            }
        }
        return true;
    }

    @Override
    public boolean checkForFailover(String liveNodeID) throws ActiveMQException {
        CheckFailoverMessage packet = new CheckFailoverMessage(liveNodeID);
        CheckFailoverReplyMessage message = (CheckFailoverReplyMessage)this.getChannel1().sendBlocking(packet, (byte)-5);
        return message.isOkToFailover();
    }

    @Override
    public RemotingConnection connect(Connection transportConnection, long callTimeout, long callFailoverTimeout, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, TopologyResponseHandler topologyResponseHandler) {
        this.connection = new RemotingConnectionImpl(this.createPacketDecoder(), transportConnection, callTimeout, callFailoverTimeout, incomingInterceptors, outgoingInterceptors);
        this.topologyResponseHandler = topologyResponseHandler;
        this.getChannel0().setHandler(new Channel0Handler(this.connection));
        this.sendHandshake(transportConnection);
        return this.connection;
    }

    protected void sendHandshake(Connection transportConnection) {
        if (transportConnection.isUsingProtocolHandling()) {
            ActiveMQBuffer amqbuffer = this.connection.createTransportBuffer(handshake.length());
            amqbuffer.writeBytes(handshake.getBytes());
            transportConnection.write(amqbuffer);
        }
    }

    protected ClusterTopologyChangeMessage updateTransportConfiguration(ClusterTopologyChangeMessage topMessage) {
        return topMessage;
    }

    protected PacketDecoder createPacketDecoder() {
        return new ClientPacketDecoder();
    }

    private void forceReturnChannel1(ActiveMQException cause) {
        Channel channel1;
        if (this.connection != null && (channel1 = this.connection.getChannel(1L, -1)) != null) {
            channel1.returnBlocking(cause);
        }
    }

    private class Channel0Handler
    implements ChannelHandler {
        private final CoreRemotingConnection conn;

        private Channel0Handler(CoreRemotingConnection conn) {
            this.conn = conn;
        }

        @Override
        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            if (type == 11 || type == 124) {
                DisconnectMessage msg = (DisconnectMessage)packet;
                String scaleDownTargetNodeID = null;
                SimpleString nodeID = msg.getNodeID();
                if (packet instanceof DisconnectMessage_V2) {
                    DisconnectMessage_V2 msg_v2 = (DisconnectMessage_V2)packet;
                    String string = scaleDownTargetNodeID = msg_v2.getScaleDownNodeID() == null ? null : msg_v2.getScaleDownNodeID().toString();
                }
                if (ActiveMQClientProtocolManager.this.topologyResponseHandler != null) {
                    ActiveMQClientProtocolManager.this.topologyResponseHandler.nodeDisconnected(this.conn, nodeID == null ? null : nodeID.toString(), scaleDownTargetNodeID);
                }
            } else if (type == 110) {
                ClusterTopologyChangeMessage topMessage = (ClusterTopologyChangeMessage)packet;
                this.notifyTopologyChange(ActiveMQClientProtocolManager.this.updateTransportConfiguration(topMessage));
            } else if (type == 114) {
                ClusterTopologyChangeMessage_V2 topMessage = (ClusterTopologyChangeMessage_V2)packet;
                this.notifyTopologyChange(ActiveMQClientProtocolManager.this.updateTransportConfiguration(topMessage));
            } else if (type == 110 || type == 114 || type == 122) {
                ClusterTopologyChangeMessage topMessage = (ClusterTopologyChangeMessage)packet;
                this.notifyTopologyChange(ActiveMQClientProtocolManager.this.updateTransportConfiguration(topMessage));
            } else if (type == -5) {
                System.out.println("Channel0Handler.handlePacket");
            }
        }

        protected void notifyTopologyChange(ClusterTopologyChangeMessage topMessage) {
            String scaleDownGroupName;
            String backupGroupName;
            long eventUID;
            if (topMessage instanceof ClusterTopologyChangeMessage_V3) {
                eventUID = ((ClusterTopologyChangeMessage_V3)topMessage).getUniqueEventID();
                backupGroupName = ((ClusterTopologyChangeMessage_V3)topMessage).getBackupGroupName();
                scaleDownGroupName = ((ClusterTopologyChangeMessage_V3)topMessage).getScaleDownGroupName();
            } else if (topMessage instanceof ClusterTopologyChangeMessage_V2) {
                eventUID = ((ClusterTopologyChangeMessage_V2)topMessage).getUniqueEventID();
                backupGroupName = ((ClusterTopologyChangeMessage_V2)topMessage).getBackupGroupName();
                scaleDownGroupName = null;
            } else {
                eventUID = System.currentTimeMillis();
                backupGroupName = null;
                scaleDownGroupName = null;
            }
            if (topMessage.isExit()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Notifying " + topMessage.getNodeID() + " going down");
                }
                if (ActiveMQClientProtocolManager.this.topologyResponseHandler != null) {
                    ActiveMQClientProtocolManager.this.topologyResponseHandler.notifyNodeDown(eventUID, topMessage.getNodeID());
                }
            } else {
                Pair<TransportConfiguration, TransportConfiguration> transportConfig = topMessage.getPair();
                if (transportConfig.getA() == null && transportConfig.getB() == null) {
                    transportConfig = new Pair<TransportConfiguration, Object>(this.conn.getTransportConnection().getConnectorConfig(), null);
                }
                if (ActiveMQClientProtocolManager.this.topologyResponseHandler != null) {
                    ActiveMQClientProtocolManager.this.topologyResponseHandler.notifyNodeUp(eventUID, topMessage.getNodeID(), backupGroupName, scaleDownGroupName, transportConfig, topMessage.isLast());
                }
            }
        }
    }
}

