/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;

public class TimeService
implements Runnable {
    protected TimeScheduler timer;
    protected Future<?> task;
    protected long interval = 500L;
    protected volatile long timestamp = System.nanoTime();
    protected final Lock lock = new ReentrantLock();

    public TimeService(TimeScheduler timer) {
        this(timer, 500L);
    }

    public TimeService(TimeScheduler timer, long interval) {
        this.timer = timer;
        this.interval = interval;
        if (timer == null) {
            throw new IllegalArgumentException("timer must not be null");
        }
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long interval() {
        return this.interval;
    }

    public TimeService interval(long interval) {
        if (interval != this.interval) {
            this.interval = interval;
        }
        return this;
    }

    public boolean running() {
        this.lock.lock();
        try {
            boolean bl = this.task != null && !this.task.isDone();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TimeService start() {
        this.lock.lock();
        try {
            if (this.task == null || this.task.isDone()) {
                this.task = this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS, false);
            }
            TimeService timeService = this;
            return timeService;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TimeService stop() {
        this.lock.lock();
        try {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
            TimeService timeService = this;
            return timeService;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        this.timestamp = System.nanoTime();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (interval=" + this.interval + "ms)";
    }
}

