/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RTTHeader
extends Header {
    public static final short RTT_ID = 1500;
    protected long send_req;
    protected long serialize_req;
    protected long deserialize_req;
    protected long receive_req;
    protected long send_rsp;
    protected long serialize_rsp;
    protected long deserialize_rsp;
    protected long rsp_dispatched;

    @Override
    public Supplier<? extends Header> create() {
        return RTTHeader::new;
    }

    @Override
    public short getMagicId() {
        return 97;
    }

    public RTTHeader sendReq(long nanos) {
        this.send_req = nanos;
        return this;
    }

    public RTTHeader serialize(long nanos) {
        if (this.serialize_req == 0L) {
            this.serialize_req = nanos;
        } else {
            this.serialize_rsp = nanos;
        }
        return this;
    }

    public RTTHeader deserialize(long nanos) {
        if (this.deserialize_req == 0L) {
            this.deserialize_req = nanos;
        } else {
            this.deserialize_rsp = nanos;
        }
        return this;
    }

    public RTTHeader receiveReq(long nanos) {
        this.receive_req = nanos;
        return this;
    }

    public RTTHeader sendRsp(long nanos) {
        this.send_rsp = nanos;
        return this;
    }

    public RTTHeader rspDispatched(long nanos) {
        this.rsp_dispatched = nanos;
        return this;
    }

    public long totalTime() {
        return this.send_req > 0L && this.rsp_dispatched > 0L ? this.rsp_dispatched - this.send_req : 0L;
    }

    public long downRequest() {
        return this.send_req > 0L && this.serialize_req > 0L ? this.serialize_req - this.send_req : 0L;
    }

    public long networkRequest() {
        return this.deserialize_req > 0L && this.serialize_req > 0L ? this.deserialize_req - this.serialize_req : 0L;
    }

    public long upReq() {
        return this.receive_req > 0L && this.deserialize_req > 0L ? this.receive_req - this.deserialize_req : 0L;
    }

    public long upRsp() {
        return this.deserialize_rsp > 0L && this.rsp_dispatched > 0L ? this.rsp_dispatched - this.deserialize_rsp : 0L;
    }

    public long processingTime() {
        return this.receive_req > 0L && this.send_rsp > 0L ? this.send_rsp - this.receive_req : 0L;
    }

    public long networkResponse() {
        return this.deserialize_rsp > 0L && this.serialize_rsp > 0L ? this.deserialize_rsp - this.serialize_rsp : 0L;
    }

    @Override
    public String toString() {
        return String.format("total=%s down req=%s network req=%s network rsp=%s", RTTHeader.print(this.totalTime()), RTTHeader.print(this.downRequest()), RTTHeader.print(this.networkRequest()), RTTHeader.print(this.networkResponse()));
    }

    @Override
    public int serializedSize() {
        return 64;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeLong(this.send_req);
        out.writeLong(this.serialize_req);
        out.writeLong(this.deserialize_req);
        out.writeLong(this.receive_req);
        out.writeLong(this.send_rsp);
        out.writeLong(this.serialize_rsp);
        out.writeLong(this.deserialize_rsp);
        out.writeLong(this.rsp_dispatched);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.send_req = in.readLong();
        this.serialize_req = in.readLong();
        this.deserialize_req = in.readLong();
        this.receive_req = in.readLong();
        this.send_rsp = in.readLong();
        this.serialize_rsp = in.readLong();
        this.deserialize_rsp = in.readLong();
        this.rsp_dispatched = in.readLong();
    }

    protected static String print(long r) {
        return r <= 0L ? "n/a" : Util.printTime(r, TimeUnit.NANOSECONDS);
    }
}

