/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import jakarta.jms.InvalidDestinationException;
import jakarta.jms.ResourceAllocationException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.AutoCreateResult;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;
import org.apache.activemq.artemis.utils.runnables.RunnableList;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQSession
implements SessionCallback {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final IDGenerator consumerIDGenerator = new SimpleIDGenerator(0L);
    private final ConnectionInfo connInfo;
    private ServerSession coreSession;
    private final SessionInfo sessInfo;
    private final ActiveMQServer server;
    private final OpenWireConnection connection;
    private final RunnableList blockedRunnables = new RunnableList();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledPool;
    private final OpenWireFormat protocolManagerWireFormat;
    private final OpenWireProtocolManager protocolManager;
    private final CoreMessageObjectPools coreMessageObjectPools;
    private String[] existingQueuesCache;
    private final SimpleString clientId;

    public AMQSession(ConnectionInfo connInfo, SessionInfo sessInfo, ActiveMQServer server, OpenWireConnection connection, OpenWireProtocolManager protocolManager, CoreMessageObjectPools coreMessageObjectPools) {
        this.connInfo = connInfo;
        this.sessInfo = sessInfo;
        this.clientId = SimpleString.of((String)connInfo.getClientId());
        this.server = server;
        this.connection = connection;
        this.protocolManager = protocolManager;
        this.scheduledPool = protocolManager.getScheduledPool();
        this.protocolManagerWireFormat = protocolManager.wireFormat().copy();
        this.existingQueuesCache = null;
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    public boolean isClosed() {
        return this.coreSession.isClosed();
    }

    public OpenWireFormat wireFormat() {
        return this.protocolManagerWireFormat;
    }

    public void initialize() {
        String name = this.sessInfo.getSessionId().toString();
        String username = this.connInfo.getUserName();
        String password = this.connInfo.getPassword();
        int minLargeMessageSize = Integer.MAX_VALUE;
        try {
            this.coreSession = this.server.createSession(name, username, password, minLargeMessageSize, (RemotingConnection)this.connection, true, false, false, false, null, (SessionCallback)this, true, this.connection.getOperationContext(), this.protocolManager.getPrefixes(), this.protocolManager.getSecurityDomain(), this.connection.getValidatedUser(), false);
        }
        catch (Exception e) {
            this.logger.error("error init session", (Throwable)e);
        }
    }

    public boolean supportsDirectDelivery() {
        return false;
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        if (consumer.getProtocolData() != null) {
            return ((AMQConsumer)consumer.getProtocolData()).updateDeliveryCountAfterCancel(ref);
        }
        return false;
    }

    public List<AMQConsumer> createConsumer(ConsumerInfo info, SlowConsumerDetectionListener slowConsumerDetectionListener) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        ActiveMQDestination[] dests = null;
        dests = dest.isComposite() ? dest.getCompositeDestinations() : new ActiveMQDestination[]{dest};
        LinkedList<AMQConsumer> consumersList = new LinkedList<AMQConsumer>();
        for (ActiveMQDestination openWireDest : dests) {
            SimpleString queueName;
            boolean isInternalAddress = false;
            if (AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)dest)) {
                if (!this.connection.isSuppportAdvisory()) continue;
                isInternalAddress = this.connection.isSuppressInternalManagementObjects();
            }
            if (openWireDest.isQueue() && !this.checkAutoCreateQueue(queueName = SimpleString.of((String)this.convertWildcard(openWireDest = this.protocolManager.virtualTopicConsumerToFQQN(openWireDest))), openWireDest.isTemporary(), OpenWireUtil.extractFilterStringOrNull(info, openWireDest))) {
                throw new InvalidDestinationException("Destination doesn't exist: " + String.valueOf(queueName));
            }
            AMQConsumer consumer = new AMQConsumer(this, openWireDest, info, this.scheduledPool, isInternalAddress);
            long nativeID = this.consumerIDGenerator.generateID();
            consumer.init(slowConsumerDetectionListener, nativeID);
            consumersList.add(consumer);
        }
        return consumersList;
    }

    private boolean checkCachedExistingQueues(SimpleString address, String physicalName, boolean isTemporary) throws Exception {
        int mask;
        int hashCode;
        int index;
        String existingQueue;
        String[] existingQueuesCache = this.existingQueuesCache;
        if (existingQueuesCache == null) {
            existingQueuesCache = new String[this.protocolManager.getOpenWireDestinationCacheSize()];
            assert (Integer.bitCount(existingQueuesCache.length) == 1) : "openWireDestinationCacheSize must be a power of 2";
            this.existingQueuesCache = existingQueuesCache;
        }
        if ((existingQueue = existingQueuesCache[index = (hashCode = physicalName.hashCode()) & (mask = existingQueuesCache.length - 1)]) != null && existingQueue.equals(physicalName)) {
            return true;
        }
        boolean hasQueue = this.checkAutoCreateQueue(address, isTemporary);
        if (hasQueue) {
            existingQueuesCache[index] = physicalName;
        }
        return hasQueue;
    }

    private boolean checkAutoCreateQueue(SimpleString queueName, boolean isTemporary) throws Exception {
        return this.checkAutoCreateQueue(queueName, isTemporary, null);
    }

    private boolean checkAutoCreateQueue(SimpleString queueName, boolean isTemporary, String filter) throws Exception {
        boolean hasQueue = true;
        if (!this.connection.containsKnownDestination(queueName)) {
            AutoCreateResult autoCreateResult;
            RoutingType routingTypeToUse = RoutingType.ANYCAST;
            if (CompositeAddress.isFullyQualified((String)queueName.toString())) {
                SimpleString addressToUse = CompositeAddress.extractAddressName((SimpleString)queueName);
                AddressInfo addressInfo = this.server.getAddressInfo(addressToUse);
                if (addressInfo != null) {
                    routingTypeToUse = addressInfo.getRoutingType();
                } else {
                    AddressSettings as = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(addressToUse.toString());
                    routingTypeToUse = as.getDefaultAddressRoutingType();
                }
            }
            if ((autoCreateResult = this.coreSession.checkAutoCreate(QueueConfiguration.of((SimpleString)queueName).setAddress(queueName).setRoutingType(routingTypeToUse).setTemporary(Boolean.valueOf(isTemporary)).setFilterString(filter))) == AutoCreateResult.NOT_FOUND) {
                throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
            }
            this.connection.addKnownDestination(queueName);
        }
        return hasQueue;
    }

    public void start() {
        this.coreSession.start();
        this.started.set(true);
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        if (theConsumer != null) {
            theConsumer.browseFinished();
        }
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        return this.connection.isWritable(callback);
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public int sendMessage(MessageReference ref, ServerConsumer consumer, int deliveryCount) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        theConsumer.removeRolledback(ref);
        return theConsumer.handleDeliver(ref, ref.getMessage().toCore());
    }

    public int sendLargeMessage(MessageReference ref, ServerConsumer consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public void closed() {
        this.blockedRunnables.cancel();
    }

    public boolean hasCredits(ServerConsumer consumer) {
        AMQConsumer amqConsumer = null;
        if (consumer.getProtocolData() != null) {
            amqConsumer = (AMQConsumer)consumer.getProtocolData();
        }
        return amqConsumer != null && amqConsumer.hasCredits();
    }

    public void disconnect(ServerConsumer serverConsumer, String errorMessage) {
        this.blockedRunnables.cancel();
        IOException forcePossibleFailoverReconnect = new IOException(errorMessage);
        try {
            this.connection.serviceException(forcePossibleFailoverReconnect);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.disconnect(forcePossibleFailoverReconnect.getMessage(), true);
    }

    private static boolean isTemporary(ProducerInfo producerInfo) {
        return producerInfo != null && producerInfo.getDestination() != null && producerInfo.getDestination().isTemporary();
    }

    public void send(ProducerInfo producerInfo, org.apache.activemq.command.Message messageSend, boolean sendProducerAck) throws Exception {
        AtomicInteger count;
        int actualDestinationsCount;
        ActiveMQDestination[] actualDestinations;
        messageSend.setBrokerInTime(System.currentTimeMillis());
        ActiveMQDestination destination = messageSend.getDestination();
        if (producerInfo.getDestination() == null) {
            this.checkDestinationForSendPermission(destination);
        }
        if (destination.isComposite()) {
            actualDestinations = destination.getCompositeDestinations();
            messageSend.setOriginalDestination(destination);
            actualDestinationsCount = actualDestinations.length;
        } else {
            actualDestinations = null;
            actualDestinationsCount = 1;
        }
        Message originalCoreMsg = OpenWireMessageConverter.inbound(messageSend, (WireFormat)this.protocolManagerWireFormat, this.coreMessageObjectPools);
        assert (this.clientId.toString().equals(this.connection.getState().getInfo().getClientId())) : "Session cached clientId must be the same of the connection";
        originalCoreMsg.putStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME, this.clientId);
        if (this.connection.getContext().isFaultTolerant() && this.protocolManager.isOpenwireUseDuplicateDetectionOnFailover() && !messageSend.getProperties().containsKey(Message.HDR_DUPLICATE_DETECTION_ID.toString()) && !AMQSession.isTemporary(producerInfo)) {
            originalCoreMsg.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.of((String)messageSend.getMessageId().toString()));
        }
        boolean shouldBlockProducer = producerInfo.getWindowSize() > 0 || messageSend.isResponseRequired();
        AtomicInteger atomicInteger = count = actualDestinations != null ? new AtomicInteger(actualDestinationsCount) : null;
        if (shouldBlockProducer) {
            this.connection.getContext().setDontSendReponse(true);
        }
        for (int i = 0; i < actualDestinationsCount; ++i) {
            ActiveMQDestination dest = actualDestinations != null ? actualDestinations[i] : destination;
            String physicalName = dest.getPhysicalName();
            SimpleString address = SimpleString.of((String)physicalName, (SimpleString.StringSimpleStringPool)this.coreMessageObjectPools.getAddressStringSimpleStringPool());
            Message coreMsg = i == actualDestinationsCount - 1 ? originalCoreMsg : originalCoreMsg.copy();
            coreMsg.setAddress(address);
            if (dest.isQueue()) {
                this.checkCachedExistingQueues(address, physicalName, dest.isTemporary());
                coreMsg.setRoutingType(RoutingType.ANYCAST);
            } else {
                coreMsg.setRoutingType(RoutingType.MULTICAST);
            }
            PagingStore store = this.server.getPagingManager().getPageStore(address);
            if (shouldBlockProducer) {
                this.sendShouldBlockProducer(producerInfo, messageSend, sendProducerAck, store, dest, count, coreMsg, address);
                continue;
            }
            if (store != null) {
                if (!store.checkMemory(true, this::restoreAutoRead, this::blockConnection, arg_0 -> ((RunnableList)this.blockedRunnables).add(arg_0))) {
                    this.restoreAutoRead();
                    throw new ResourceAllocationException("Queue is full " + String.valueOf(address));
                }
            } else {
                this.restoreAutoRead();
            }
            this.getCoreSession().send(coreMsg, false, producerInfo.getProducerId().toString(), dest.isTemporary());
            if (count != null && count.decrementAndGet() != 0 || !sendProducerAck) continue;
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
            this.connection.dispatchAsync((Command)ack);
        }
    }

    private void sendShouldBlockProducer(final ProducerInfo producerInfo, final org.apache.activemq.command.Message messageSend, final boolean sendProducerAck, PagingStore store, final ActiveMQDestination dest, final AtomicInteger count, final Message coreMsg, SimpleString address) throws ResourceAllocationException {
        AtomicRunnable task = new AtomicRunnable(){

            public void atomicRun() {
                Exception exceptionToSend = null;
                try {
                    AMQSession.this.getCoreSession().send(coreMsg, false, producerInfo.getProducerId().toString(), dest.isTemporary());
                }
                catch (Exception e) {
                    AMQSession.this.logger.debug("Sending exception to the client", (Throwable)e);
                    exceptionToSend = e;
                }
                AMQSession.this.connection.enableTtl();
                if (count == null || count.decrementAndGet() == 0) {
                    if (exceptionToSend != null) {
                        AMQSession.this.connection.getContext().setDontSendReponse(false);
                        AMQSession.this.connection.sendException(exceptionToSend);
                    } else {
                        AMQSession.this.server.getStorageManager().afterCompleteOperations(new IOCallback(){

                            public void done() {
                                if (sendProducerAck) {
                                    try {
                                        ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
                                        AMQSession.this.connection.dispatchAsync((Command)ack);
                                    }
                                    catch (Exception e) {
                                        AMQSession.this.connection.getContext().setDontSendReponse(false);
                                        AMQSession.this.logger.warn(e.getMessage(), (Throwable)e);
                                        AMQSession.this.connection.sendException(e);
                                    }
                                } else {
                                    AMQSession.this.connection.getContext().setDontSendReponse(false);
                                    try {
                                        Response response = new Response();
                                        response.setCorrelationId(messageSend.getCommandId());
                                        AMQSession.this.connection.dispatchAsync((Command)response);
                                    }
                                    catch (Exception e) {
                                        AMQSession.this.logger.warn(e.getMessage(), (Throwable)e);
                                        AMQSession.this.connection.sendException(e);
                                    }
                                }
                            }

                            public void onError(int errorCode, String errorMessage) {
                                try {
                                    IOException e = new IOException(errorMessage);
                                    AMQSession.this.logger.warn(errorMessage);
                                    AMQSession.this.connection.serviceException(e);
                                }
                                catch (Exception ex) {
                                    AMQSession.this.logger.debug(ex.getMessage(), (Throwable)ex);
                                }
                            }
                        });
                    }
                }
            }
        };
        if (store != null) {
            if (!store.checkMemory(false, (Runnable)task, null, arg_0 -> ((RunnableList)this.blockedRunnables).add(arg_0))) {
                this.connection.getContext().setDontSendReponse(false);
                this.connection.enableTtl();
                throw new ResourceAllocationException("Queue is full " + String.valueOf(address));
            }
        } else {
            task.run();
        }
    }

    private void restoreAutoRead() {
        this.connection.restoreAutoRead();
    }

    private void blockConnection() {
        this.connection.blockConnection();
    }

    public String convertWildcard(ActiveMQDestination openWireDest) {
        if (openWireDest.isTemporary() || AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)openWireDest)) {
            return openWireDest.getPhysicalName();
        }
        return OpenWireUtil.OPENWIRE_WILDCARD.convert(openWireDest.getPhysicalName(), this.server.getConfiguration().getWildcardConfiguration());
    }

    public ServerSession getCoreSession() {
        return this.coreSession;
    }

    public ActiveMQServer getCoreServer() {
        return this.server;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    public void disableSecurity() {
        this.coreSession.disableSecurity();
    }

    public void deliverMessage(MessageDispatch dispatch) {
        this.connection.deliverMessage(dispatch);
    }

    public void close() throws Exception {
        this.close(false);
    }

    public void close(boolean failed) {
        this.blockedRunnables.cancel();
        try {
            this.coreSession.close(failed);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OpenWireConnection getConnection() {
        return this.connection;
    }

    public boolean isInternal() {
        return this.sessInfo.getSessionId().getValue() == -1L;
    }

    public void checkDestinationForSendPermission(ActiveMQDestination destination) throws Exception {
        if (this.server.getSecurityStore().isSecurityEnabled()) {
            if (destination.isComposite()) {
                for (ActiveMQDestination composite : destination.getCompositeDestinations()) {
                    this.doCheckDestinationForSendPermission(composite);
                }
            } else {
                this.doCheckDestinationForSendPermission(destination);
            }
        }
    }

    private void doCheckDestinationForSendPermission(ActiveMQDestination destination) throws Exception {
        SimpleString destinationName = SimpleString.of((String)destination.getPhysicalName());
        SimpleString address = CompositeAddress.extractAddressName((SimpleString)destinationName);
        SimpleString queue = CompositeAddress.isFullyQualified((SimpleString)destinationName) ? CompositeAddress.extractQueueName((SimpleString)destinationName) : null;
        this.server.getSecurityStore().check(address, queue, CheckType.SEND, (SecurityAuth)this.getCoreSession());
    }
}

