/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import jakarta.jms.InvalidClientIDException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireFrameParser;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireInterceptor;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireRoutingHandler;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.selector.impl.LRUCache;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.DestinationPath;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWireProtocolManager
extends AbstractProtocolManager<Command, OpenWireInterceptor, OpenWireConnection, OpenWireRoutingHandler>
implements ClusterTopologyListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> websocketRegistryNames = Collections.emptyList();
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final ActiveMQServer server;
    private final OpenWireProtocolManagerFactory factory;
    private final OpenWireFormatFactory wireFactory;
    private boolean prefixPacketSize = true;
    private int actorThresholdBytes = -1;
    private BrokerId brokerId;
    protected final ProducerId advisoryProducerId = new ProducerId();
    private final List<OpenWireConnection> connections = new CopyOnWriteArrayList<OpenWireConnection>();
    private final ConcurrentMap<String, OpenWireConnection> clientIdSet = new ConcurrentHashMap<String, OpenWireConnection>();
    private String brokerName;
    private final Map<String, TopologyMember> topologyMap = new ConcurrentHashMap<String, TopologyMember>();
    private final LinkedList<TopologyMember> members = new LinkedList();
    private final ScheduledExecutorService scheduledPool;
    private String securityDomain;
    private boolean rebalanceClusterClients = false;
    private boolean updateClusterClients = false;
    private boolean updateClusterClientsOnRemove = false;
    private boolean openwireUseDuplicateDetectionOnFailover = true;
    private int openwireMaxPacketChunkSize = 102400;
    private long maxInactivityDuration = 30000L;
    private long maxInactivityDurationInitalDelay = 10000L;
    private boolean useKeepAlive = true;
    private boolean supportAdvisory = true;
    private boolean suppressInternalManagementObjects = true;
    private int openWireDestinationCacheSize = 16;
    private final OpenWireFormat wireFormat;
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();
    private final List<OpenWireInterceptor> incomingInterceptors = new ArrayList<OpenWireInterceptor>();
    private final List<OpenWireInterceptor> outgoingInterceptors = new ArrayList<OpenWireInterceptor>();
    private final OpenWireRoutingHandler routingHandler;
    private final Map<DestinationFilter, VirtualTopicConfig> vtConsumerDestinationMatchers = new HashMap<DestinationFilter, VirtualTopicConfig>();
    protected final LRUCache<ActiveMQDestination, ActiveMQDestination> vtDestMapCache = new LRUCache();

    public int getOpenwireMaxPacketChunkSize() {
        return this.openwireMaxPacketChunkSize;
    }

    public OpenWireProtocolManager setOpenwireMaxPacketChunkSize(int openwireMaxPacketChunkSize) {
        this.openwireMaxPacketChunkSize = openwireMaxPacketChunkSize;
        return this;
    }

    public OpenWireProtocolManager(OpenWireProtocolManagerFactory factory, ActiveMQServer server, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
        this.factory = factory;
        this.server = server;
        this.wireFactory = new OpenWireFormatFactory();
        this.wireFactory.setCacheEnabled(false);
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
        this.scheduledPool = server.getScheduledPool();
        this.wireFormat = (OpenWireFormat)this.wireFactory.createWireFormat();
        this.updateInterceptors(incomingInterceptors, outgoingInterceptors);
        ClusterManager clusterManager = this.server.getClusterManager();
        ClusterConnection cc = clusterManager.getDefaultConnection(null);
        if (cc != null) {
            cc.addClusterTopologyListener((ClusterTopologyListener)this);
        }
        clusterManager.addProtocolIgnoredAddress("ActiveMQ.Advisory.");
        this.routingHandler = new OpenWireRoutingHandler(server, this);
    }

    public boolean isOpenwireUseDuplicateDetectionOnFailover() {
        return this.openwireUseDuplicateDetectionOnFailover;
    }

    public OpenWireProtocolManager setOpenwireUseDuplicateDetectionOnFailover(boolean openwireUseDuplicateDetectionOnFailover) {
        this.openwireUseDuplicateDetectionOnFailover = openwireUseDuplicateDetectionOnFailover;
        return this;
    }

    public void nodeUP(TopologyMember member, boolean last) {
        if (member.getPrimary() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} ignoring nodeUP call due to null primary; topologyMember={}, last={}", new Object[]{this, member, last});
            }
            return;
        }
        if (this.topologyMap.put(member.getNodeId(), member) == null) {
            this.updateClientClusterInfo();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
        if (this.topologyMap.remove(nodeID) != null) {
            this.updateClientClusterInfo();
        }
    }

    public void removeConnection(String clientID, OpenWireConnection connection) {
        this.clientIdSet.remove(clientID, (Object)connection);
        this.connections.remove((Object)connection);
    }

    public int getActorThresholdBytes() {
        return this.actorThresholdBytes;
    }

    public OpenWireProtocolManager setActorThresholdBytes(int actorThresholdBytes) {
        this.actorThresholdBytes = actorThresholdBytes;
        return this;
    }

    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientClusterInfo() {
        LinkedList<TopologyMember> linkedList = this.members;
        synchronized (linkedList) {
            this.members.clear();
            this.members.addAll(this.topologyMap.values());
        }
        for (OpenWireConnection c : this.connections) {
            ConnectionControl control = this.newConnectionControl();
            try {
                c.updateClient(control);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                c.sendException(e);
            }
        }
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ProtocolManagerFactory getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List incoming, List outgoing) {
        this.incomingInterceptors.clear();
        if (incoming != null) {
            this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        }
        this.outgoingInterceptors.clear();
        if (outgoing != null) {
            this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
        }
    }

    public String invokeIncoming(Command command, OpenWireConnection connection) {
        return super.invokeInterceptors(this.incomingInterceptors, (Object)command, (RemotingConnection)connection);
    }

    public String invokeOutgoing(Command command, OpenWireConnection connection) {
        return super.invokeInterceptors(this.outgoingInterceptors, (Object)command, (RemotingConnection)connection);
    }

    private int getActorThreadshold(Acceptor acceptorUsed) {
        int actorThreshold = 0x100000;
        if (acceptorUsed instanceof NettyAcceptor) {
            NettyAcceptor acceptor = (NettyAcceptor)acceptorUsed;
            actorThreshold = acceptor.getTcpReceiveBufferSize();
        }
        if (this.actorThresholdBytes > 0) {
            actorThreshold = this.actorThresholdBytes;
        }
        return actorThreshold;
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        OpenWireFormat wf = (OpenWireFormat)this.wireFactory.createWireFormat();
        OpenWireConnection owConn = new OpenWireConnection(connection, this.server, this, wf, (Executor)this.server.getExecutorFactory().getExecutor(), this.getActorThreadshold(acceptorUsed));
        owConn.sendHandshake();
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)owConn, null, System.currentTimeMillis(), -1L);
        owConn.setConnectionEntry(entry);
        return entry;
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("large-frame-dealer", (ChannelHandler)new OpenWireFrameParser(this.openwireMaxPacketChunkSize));
    }

    public boolean isProtocol(byte[] array) {
        int remainingLen;
        if (array.length < 8) {
            throw new IllegalArgumentException("Protocol header length changed " + array.length);
        }
        int start = this.prefixPacketSize ? 4 : 0;
        int j = 0;
        if (array[start] != 1) {
            return false;
        }
        WireFormatInfo info = new WireFormatInfo();
        byte[] magic = info.getMagic();
        int useLen = (remainingLen = array.length - ++start) > magic.length ? magic.length : remainingLen;
        useLen += start;
        for (int i = start; i < useLen; ++i) {
            if (array[i] != magic[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public void validateUser(OpenWireConnection connection, ConnectionInfo info) throws Exception {
        String username = info.getUserName();
        String password = info.getPassword();
        try {
            connection.setValidatedUser(this.validateUser(username, password, connection));
        }
        catch (ActiveMQSecurityException e) {
            SecurityException ex = new SecurityException("User name [" + username + "] or password is invalid.");
            ex.initCause(e);
            throw ex;
        }
    }

    public void addConnection(OpenWireConnection connection, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        OpenWireConnection oldConnection = (OpenWireConnection)((Object)this.clientIdSet.get(clientId));
        if (oldConnection != null && !info.isFailoverReconnect()) {
            throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldConnection.getRemoteAddress());
        }
        AMQConnectionContext context = connection.initContext(info);
        this.clientIdSet.put(clientId, connection);
        this.connections.add(connection);
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        ConnectionInfo copy = info.copy();
        copy.setPassword("");
        this.fireAdvisory(context, topic, (Command)copy);
        context.getConnection().addSessions(context.getConnectionState().getSessionIds());
    }

    public void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command copy) throws Exception {
        this.fireAdvisory(context, topic, copy, null, null);
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    public void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId, String originalConnectionId) throws Exception {
        if (!this.isSupportAdvisory()) {
            return;
        }
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        if (originalConnectionId == null) {
            originalConnectionId = context.getConnectionId().getValue();
        }
        advisoryMessage.setStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString(), originalConnectionId);
        advisoryMessage.setStringProperty("originBrokerName", this.getBrokerName());
        String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
        advisoryMessage.setStringProperty("originBrokerId", id);
        advisoryMessage.setStringProperty("originBrokerURL", context.getConnection().getLocalAddress());
        advisoryMessage.setDataStructure((DataStructure)command);
        advisoryMessage.setPersistent(false);
        advisoryMessage.setType("Advisory");
        advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        advisoryMessage.setTargetConsumerId(targetConsumerId);
        advisoryMessage.setDestination((ActiveMQDestination)topic);
        advisoryMessage.setResponseRequired(false);
        advisoryMessage.setProducerId(this.advisoryProducerId);
        advisoryMessage.setTimestamp(System.currentTimeMillis());
        CoreMessageObjectPools objectPools = context.getConnection().getCoreMessageObjectPools();
        Message coreMessage = OpenWireMessageConverter.inbound((org.apache.activemq.command.Message)advisoryMessage, (WireFormat)this.wireFormat, objectPools);
        SimpleString address = SimpleString.of((String)topic.getPhysicalName(), (SimpleString.StringSimpleStringPool)objectPools.getAddressStringSimpleStringPool());
        coreMessage.setAddress(address);
        coreMessage.setRoutingType(RoutingType.MULTICAST);
        this.server.getPostOffice().route(coreMessage, false);
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = this.server.getNodeID().toString();
            }
        }
        return this.brokerName;
    }

    protected ConnectionControl newConnectionControl() {
        ConnectionControl control = new ConnectionControl();
        String uri = this.generateMembersURI(this.rebalanceClusterClients);
        control.setConnectedBrokers(uri);
        control.setRebalanceConnection(this.rebalanceClusterClients);
        return control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateMembersURI(boolean flip) {
        StringBuilder connectedBrokers = new StringBuilder();
        String separator = "";
        LinkedList<TopologyMember> linkedList = this.members;
        synchronized (linkedList) {
            if (!this.members.isEmpty()) {
                for (TopologyMember member : this.members) {
                    connectedBrokers.append(separator).append(member.toURI());
                    separator = ",";
                }
                if (flip && this.members.size() > 1) {
                    this.members.addLast(this.members.removeFirst());
                }
            }
        }
        String uri = connectedBrokers.toString();
        return uri;
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    public void postProcessDispatch(MessageDispatch md) {
    }

    public boolean isStopped() {
        return false;
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
    }

    public boolean isStopping() {
        return false;
    }

    public String validateUser(String login, String passcode, OpenWireConnection connection) throws Exception {
        return this.server.validateUser(login, passcode, (RemotingConnection)connection, this.getSecurityDomain());
    }

    public void sendBrokerInfo(OpenWireConnection connection) throws Exception {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerName(this.getBrokerName());
        brokerInfo.setBrokerId(new BrokerId(String.valueOf(this.server.getNodeID())));
        brokerInfo.setPeerBrokerInfos(null);
        brokerInfo.setFaultTolerantConfiguration(false);
        brokerInfo.setBrokerURL(connection.getLocalAddress());
        brokerInfo.setPeerBrokerInfos(null);
        connection.dispatch((Command)brokerInfo);
    }

    public void configureInactivityParams(OpenWireConnection connection, WireFormatInfo command) throws IOException {
        long inactivityDurationToUse = command.getMaxInactivityDuration() > this.maxInactivityDuration ? this.maxInactivityDuration : command.getMaxInactivityDuration();
        long inactivityDurationInitialDelayToUse = command.getMaxInactivityDurationInitalDelay() > this.maxInactivityDurationInitalDelay ? this.maxInactivityDurationInitalDelay : command.getMaxInactivityDurationInitalDelay();
        boolean useKeepAliveToUse = inactivityDurationToUse == 0L ? false : this.useKeepAlive;
        connection.setUpTtl(inactivityDurationToUse, inactivityDurationInitialDelayToUse, useKeepAliveToUse);
    }

    public void setRebalanceClusterClients(boolean rebalance) {
        this.rebalanceClusterClients = rebalance;
    }

    public boolean isRebalanceClusterClients() {
        return this.rebalanceClusterClients;
    }

    public void setUpdateClusterClients(boolean updateClusterClients) {
        this.updateClusterClients = updateClusterClients;
    }

    public boolean isUpdateClusterClients() {
        return this.updateClusterClients;
    }

    public void setUpdateClusterClientsOnRemove(boolean updateClusterClientsOnRemove) {
        this.updateClusterClientsOnRemove = updateClusterClientsOnRemove;
    }

    public boolean isUpdateClusterClientsOnRemove() {
        return this.updateClusterClientsOnRemove;
    }

    public void setBrokerName(String name) {
        this.brokerName = name;
    }

    public boolean isUseKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public long getMaxInactivityDurationInitalDelay() {
        return this.maxInactivityDurationInitalDelay;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) {
        this.maxInactivityDurationInitalDelay = maxInactivityDurationInitalDelay;
    }

    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.of((String)prefix), RoutingType.ANYCAST);
        }
    }

    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.of((String)prefix), RoutingType.MULTICAST);
        }
    }

    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public OpenWireRoutingHandler getRoutingHandler() {
        return this.routingHandler;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public List<DestinationInfo> getTemporaryDestinations() {
        ArrayList<DestinationInfo> total = new ArrayList<DestinationInfo>();
        for (OpenWireConnection connection : this.connections) {
            total.addAll(connection.getTemporaryDestinations());
        }
        return total;
    }

    public OpenWireFormat wireFormat() {
        return this.wireFormat;
    }

    public boolean isSupportAdvisory() {
        return this.supportAdvisory;
    }

    public void setSupportAdvisory(boolean supportAdvisory) {
        this.supportAdvisory = supportAdvisory;
    }

    public boolean isSuppressInternalManagementObjects() {
        return this.suppressInternalManagementObjects;
    }

    public void setSuppressInternalManagementObjects(boolean suppressInternalManagementObjects) {
        this.suppressInternalManagementObjects = suppressInternalManagementObjects;
    }

    public int getOpenWireDestinationCacheSize() {
        return this.openWireDestinationCacheSize;
    }

    public void setOpenWireDestinationCacheSize(int openWireDestinationCacheSize) {
        this.openWireDestinationCacheSize = openWireDestinationCacheSize;
    }

    public void setVirtualTopicConsumerWildcards(String virtualTopicConsumerWildcards) {
        for (String filter : virtualTopicConsumerWildcards.split(",")) {
            String[] configuration = filter.split(";");
            this.vtConsumerDestinationMatchers.put(DestinationFilter.parseFilter((ActiveMQDestination)new ActiveMQQueue(configuration[0])), new VirtualTopicConfig(configuration));
        }
    }

    public void setVirtualTopicConsumerLruCacheMax(int max) {
        this.vtDestMapCache.setMaxCacheSize(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQDestination virtualTopicConsumerToFQQN(ActiveMQDestination destination) {
        if (this.vtConsumerDestinationMatchers.isEmpty()) {
            return destination;
        }
        ActiveMQDestination mappedDestination = null;
        Object object = this.vtDestMapCache;
        synchronized (object) {
            mappedDestination = (ActiveMQDestination)this.vtDestMapCache.get((Object)destination);
        }
        if (mappedDestination != null) {
            return mappedDestination;
        }
        for (Map.Entry entry : this.vtConsumerDestinationMatchers.entrySet()) {
            int i;
            if (!((DestinationFilter)entry.getKey()).matches(destination)) continue;
            String[] paths = DestinationPath.getDestinationPaths((ActiveMQDestination)destination);
            StringBuilder fqqn = new StringBuilder();
            VirtualTopicConfig virtualTopicConfig = (VirtualTopicConfig)entry.getValue();
            for (i = virtualTopicConfig.filterPathTerminus; i < paths.length; ++i) {
                if (i > virtualTopicConfig.filterPathTerminus) {
                    fqqn.append(".");
                }
                fqqn.append(paths[i]);
            }
            fqqn.append("::");
            for (i = 0; i < paths.length; ++i) {
                if (i > 0) {
                    fqqn.append(".");
                }
                fqqn.append(paths[i]);
            }
            mappedDestination = new ActiveMQQueue(fqqn.toString() + (virtualTopicConfig.selectorAware ? "?selectorAware=true" : ""));
            break;
        }
        if (mappedDestination == null) {
            mappedDestination = destination;
        }
        object = this.vtDestMapCache;
        synchronized (object) {
            ActiveMQDestination activeMQDestination = (ActiveMQDestination)this.vtDestMapCache.put((Object)destination, (Object)mappedDestination);
            if (activeMQDestination != null) {
                this.vtDestMapCache.put((Object)destination, (Object)activeMQDestination);
                mappedDestination = activeMQDestination;
            }
        }
        return mappedDestination;
    }

    public List<OpenWireConnection> getConnections() {
        return this.connections;
    }

    protected static class VirtualTopicConfig {
        public int filterPathTerminus;
        public boolean selectorAware;

        public VirtualTopicConfig(String[] configuration) {
            this.filterPathTerminus = Integer.parseInt(configuration[1]);
            for (int i = 2; i < configuration.length; ++i) {
                String[] optionPair = configuration[i].split("=");
                this.consumeOption(optionPair);
            }
        }

        private void consumeOption(String[] optionPair) {
            if (optionPair.length == 2 && "selectorAware".equals(optionPair[0])) {
                this.selectorAware = Boolean.parseBoolean(optionPair[1]);
            }
        }
    }
}

