/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSessionMessage
extends PacketImpl {
    private String name;
    private long sessionChannelID;
    private int version;
    private String username;
    private String password;
    private int minLargeMessageSize;
    private boolean xa;
    private boolean autoCommitSends;
    private boolean autoCommitAcks;
    private boolean preAcknowledge;
    private int windowSize;
    private String defaultAddress;

    public CreateSessionMessage(String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress) {
        this(30, name, sessionChannelID, version, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, windowSize, defaultAddress);
    }

    protected CreateSessionMessage(byte type, String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress) {
        super(type);
        this.name = name;
        this.sessionChannelID = sessionChannelID;
        this.version = version;
        this.username = username;
        this.password = password;
        this.minLargeMessageSize = minLargeMessageSize;
        this.xa = xa;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.windowSize = windowSize;
        this.preAcknowledge = preAcknowledge;
        this.defaultAddress = defaultAddress;
    }

    public CreateSessionMessage() {
        super((byte)30);
    }

    protected CreateSessionMessage(byte type) {
        super(type);
    }

    public String getName() {
        return this.name;
    }

    public long getSessionChannelID() {
        return this.sessionChannelID;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isXA() {
        return this.xa;
    }

    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeLong(this.sessionChannelID);
        buffer.writeInt(this.version);
        buffer.writeNullableString(this.username);
        buffer.writeNullableString(this.password);
        buffer.writeInt(this.minLargeMessageSize);
        buffer.writeBoolean(this.xa);
        buffer.writeBoolean(this.autoCommitSends);
        buffer.writeBoolean(this.autoCommitAcks);
        buffer.writeInt(this.windowSize);
        buffer.writeBoolean(this.preAcknowledge);
        buffer.writeNullableString(this.defaultAddress);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.sessionChannelID = buffer.readLong();
        this.version = buffer.readInt();
        this.username = buffer.readNullableString();
        this.password = buffer.readNullableString();
        this.minLargeMessageSize = buffer.readInt();
        this.xa = buffer.readBoolean();
        this.autoCommitSends = buffer.readBoolean();
        this.autoCommitAcks = buffer.readBoolean();
        this.windowSize = buffer.readInt();
        this.preAcknowledge = buffer.readBoolean();
        this.defaultAddress = buffer.readNullableString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.autoCommitAcks, this.autoCommitSends, this.defaultAddress, this.minLargeMessageSize, this.name, this.password, this.preAcknowledge, this.sessionChannelID, this.username, this.version, this.windowSize, this.xa);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", autoCommitAcks=" + this.autoCommitAcks);
        sb.append(", autoCommitSends=" + this.autoCommitSends);
        sb.append(", defaultAddress=" + this.defaultAddress);
        sb.append(", minLargeMessageSize=" + this.minLargeMessageSize);
        sb.append(", name=" + this.name);
        sb.append(", password=****");
        sb.append(", preAcknowledge=" + this.preAcknowledge);
        sb.append(", sessionChannelID=" + this.sessionChannelID);
        sb.append(", username=" + this.username);
        sb.append(", version=" + this.version);
        sb.append(", windowSize=" + this.windowSize);
        sb.append(", xa=" + this.xa);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSessionMessage)) {
            return false;
        }
        CreateSessionMessage other = (CreateSessionMessage)obj;
        return this.autoCommitAcks == other.autoCommitAcks && this.autoCommitSends == other.autoCommitSends && Objects.equals(this.defaultAddress, other.defaultAddress) && this.minLargeMessageSize == other.minLargeMessageSize && Objects.equals(this.name, other.name) && Objects.equals(this.password, other.password) && this.preAcknowledge == other.preAcknowledge && this.sessionChannelID == other.sessionChannelID && Objects.equals(this.username, other.username) && this.version == other.version && this.windowSize == other.windowSize && this.xa == other.xa;
    }
}

