/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.auth.AuthToken;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;

public class AuthHeader
extends Header {
    protected AuthToken token = null;

    public AuthHeader() {
    }

    public AuthHeader(AuthToken token) {
        this.token = token;
    }

    @Override
    public Supplier<? extends Header> create() {
        return AuthHeader::new;
    }

    public AuthHeader setToken(AuthToken token) {
        this.token = token;
        return this;
    }

    public AuthToken getToken() {
        return this.token;
    }

    public AuthHeader token(AuthToken token) {
        this.token = token;
        return this;
    }

    public AuthToken token() {
        return this.token;
    }

    @Override
    public short getMagicId() {
        return 66;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        AuthHeader.writeAuthToken(out, this.token);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.token = AuthHeader.readAuthToken(in);
    }

    @Override
    public int serializedSize() {
        return AuthHeader.sizeOf(this.token);
    }

    @Override
    public String toString() {
        return "token=" + this.token;
    }

    protected static void writeAuthToken(DataOutput out, AuthToken tok) throws IOException {
        out.writeByte(tok == null ? 0 : 1);
        if (tok == null) {
            return;
        }
        short id = ClassConfigurator.getMagicNumber(tok.getClass());
        out.writeShort(id);
        if (id < 0) {
            String classname = tok.getClass().getName();
            out.writeUTF(classname);
        }
        tok.writeTo(out);
    }

    protected static AuthToken readAuthToken(DataInput in) throws IOException, ClassNotFoundException {
        if (in.readByte() == 0) {
            return null;
        }
        short id = in.readShort();
        AuthToken retval = null;
        if (id >= 0) {
            retval = (AuthToken)ClassConfigurator.create(id);
        } else {
            String classname = in.readUTF();
            Class<?> clazz = Class.forName(classname);
            try {
                retval = (AuthToken)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        retval.readFrom(in);
        return retval;
    }

    protected static int sizeOf(AuthToken tok) {
        int retval = 1;
        if (tok == null) {
            return retval;
        }
        retval += 2;
        short id = ClassConfigurator.getMagicNumber(tok.getClass());
        if (id < 0) {
            String classname = tok.getClass().getName();
            retval += classname.length() + 2;
        }
        return retval += tok.size();
    }
}

