/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<V>
implements Future<V> {
    V value;
    Exception exception;
    private final CountDownLatch latch = new CountDownLatch(1);
    boolean canceled = false;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.canceled = true;
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() <= 0L;
    }

    public void fail(Exception e) {
        this.exception = e;
        this.latch.countDown();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.value;
    }

    public void set(V v) {
        this.value = v;
        this.latch.countDown();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        return this.value;
    }
}

