/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;

@Command(name="consumer", description="It will consume messages from an instance")
public class Consumer
extends DestAbstract {
    @Option(name={"--durable"}, description="It will use durable subscription in case of client")
    boolean durable = false;
    @Option(name={"--break-on-null"}, description="It will break on null messages")
    boolean breakOnNull = false;
    @Option(name={"--receive-timeout"}, description="Time used on receive(timeout)")
    int receiveTimeout = 3000;
    @Option(name={"--filter"}, description="filter to be used with the consumer")
    String filter;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        System.out.println("Consumer:: filter = " + this.filter);
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        ActiveMQDestination dest = ActiveMQDestination.createDestination((String)this.destination, (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        try (Connection connection = factory.createConnection();){
            ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var8_11;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                threadsArray[i] = new ConsumerThread((Session)var8_11, (Destination)dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setDurable(this.durable).setBatchSize(this.txBatchSize).setBreakOnNull(this.breakOnNull).setMessageCount(this.messageCount).setReceiveTimeOut(this.receiveTimeout).setFilter(this.filter).setBrowse(false);
            }
            for (ConsumerThread thread : threadsArray) {
                thread.start();
            }
            connection.start();
            int received = 0;
            for (ConsumerThread thread : threadsArray) {
                thread.join();
                received += thread.getReceived();
            }
            Integer n = received;
            return n;
        }
    }
}

