/*
 * Decompiled with CFR 0.152.
 */
package org.apache.artemis.client.cdi.factory;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.jms.JMSContext;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.artemis.client.cdi.configuration.ArtemisClientConfiguration;

@ApplicationScoped
public class ConnectionFactoryProvider {
    @Produces
    @ApplicationScoped
    private ActiveMQConnectionFactory activeMQConnectionFactory;
    @Inject
    private ArtemisClientConfiguration configuration;
    @Inject
    private Configuration embeddedConfiguration;

    @PostConstruct
    public void setupConnection() {
        if (this.configuration.startEmbeddedBroker()) {
            try {
                ActiveMQServer activeMQServer = ActiveMQServers.newActiveMQServer((Configuration)this.embeddedConfiguration, (boolean)false);
                JMSServerManagerImpl jmsServerManager = new JMSServerManagerImpl(activeMQServer);
                jmsServerManager.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to start embedded JMS", e);
            }
        }
        try {
            this.activeMQConnectionFactory = this.createConnectionFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to connect to remote server", e);
        }
    }

    @Produces
    @ApplicationScoped
    public JMSContext createJMSContext() {
        return this.activeMQConnectionFactory.createContext();
    }

    private ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serverId", "1");
        if (this.configuration.getUrl() != null) {
            activeMQConnectionFactory = ActiveMQJMSClient.createConnectionFactory((String)this.configuration.getUrl(), null);
        } else {
            if (this.configuration.getHost() != null) {
                params.put("host", this.configuration.getHost());
                params.put("port", this.configuration.getPort());
            }
            activeMQConnectionFactory = this.configuration.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(this.configuration.getConnectorFactory(), params)}) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(this.configuration.getConnectorFactory(), params)});
        }
        if (this.configuration.hasAuthentication()) {
            activeMQConnectionFactory.setUser(this.configuration.getUsername());
            activeMQConnectionFactory.setPassword(this.configuration.getPassword());
        }
        return activeMQConnectionFactory.disableFinalizeChecks();
    }
}

