/*
 * Decompiled with CFR 0.152.
 */
package org.apache.artemis.client.cdi.extension;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.artemis.client.cdi.configuration.ArtemisClientConfiguration;
import org.apache.artemis.client.cdi.extension.ArtemisClientConfigBean;
import org.apache.artemis.client.cdi.extension.ArtemisEmbeddedServerConfigBean;
import org.apache.artemis.client.cdi.logger.ActiveMQCDILogger;

public class ArtemisExtension
implements Extension {
    private boolean foundEmbeddedConfig = false;
    private boolean foundConfiguration = false;

    <T extends ArtemisClientConfiguration> void foundClientConfig(@Observes ProcessAnnotatedType<T> pat) {
        ActiveMQCDILogger.LOGGER.discoveredConfiguration(pat);
        this.foundConfiguration = true;
    }

    <T extends Configuration> void foundEmbeddedConfig(@Observes ProcessAnnotatedType<T> pat) {
        ActiveMQCDILogger.LOGGER.discoveredClientConfiguration(pat);
        this.foundEmbeddedConfig = true;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        if (!this.foundConfiguration) {
            afterBeanDiscovery.addBean((Bean)new ArtemisClientConfigBean());
        } else {
            ActiveMQCDILogger.LOGGER.notUsingDefaultConfiguration();
        }
        if (!this.foundEmbeddedConfig) {
            afterBeanDiscovery.addBean((Bean)new ArtemisEmbeddedServerConfigBean());
        } else {
            ActiveMQCDILogger.LOGGER.notUsingDefaultClientConfiguration();
        }
    }
}

