/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.message.EncodedMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.InboundTransformer;
import org.apache.activemq.artemis.utils.IDGenerator;

public class AMQPRawInboundTransformer
extends InboundTransformer {
    public AMQPRawInboundTransformer(IDGenerator idGenerator) {
        super(idGenerator);
    }

    @Override
    public String getTransformerName() {
        return "raw";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return null;
    }

    @Override
    public ServerJMSMessage transform(EncodedMessage amqpMessage) throws Exception {
        ServerJMSBytesMessage message = AMQPMessageSupport.createBytesMessage(this.idGenerator);
        message.writeBytes(amqpMessage.getArray(), amqpMessage.getArrayOffset(), amqpMessage.getLength());
        message.setJMSDeliveryMode(2);
        message.setJMSPriority(4);
        message.setJMSTimestamp(System.currentTimeMillis());
        message.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        message.setBooleanProperty("JMS_AMQP_NATIVE", true);
        return message;
    }
}

