/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerDestination;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.message.EncodedMessage;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;

public abstract class InboundTransformer {
    protected IDGenerator idGenerator;
    public static final String TRANSFORMER_NATIVE = "native";
    public static final String TRANSFORMER_RAW = "raw";
    public static final String TRANSFORMER_JMS = "jms";

    public InboundTransformer(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public abstract ServerJMSMessage transform(EncodedMessage var1) throws Exception;

    public abstract String getTransformerName();

    public abstract InboundTransformer getFallbackTransformer();

    protected ServerJMSMessage populateMessage(ServerJMSMessage jms, org.apache.qpid.proton.message.Message amqp) throws Exception {
        Footer footer;
        Properties properties;
        ApplicationProperties ap;
        MessageAnnotations ma;
        Header header = amqp.getHeader();
        if (header != null) {
            jms.setBooleanProperty("JMS_AMQP_HEADER", true);
            if (header.getDurable() != null) {
                jms.setJMSDeliveryMode(header.getDurable() != false ? 2 : 1);
            } else {
                jms.setJMSDeliveryMode(2);
            }
            if (header.getPriority() != null) {
                jms.setJMSPriority(header.getPriority().intValue());
            } else {
                jms.setJMSPriority(4);
            }
            if (header.getFirstAcquirer() != null) {
                jms.setBooleanProperty("JMS_AMQP_FirstAcquirer", header.getFirstAcquirer());
            }
            if (header.getDeliveryCount() != null) {
                jms.setLongProperty("JMSXDeliveryCount", header.getDeliveryCount().longValue() + 1L);
            }
        } else {
            jms.setJMSPriority(4);
            jms.setJMSDeliveryMode(1);
        }
        if ((ma = amqp.getMessageAnnotations()) != null) {
            for (Map.Entry entry : ma.getValue().entrySet()) {
                long delay;
                String string = entry.getKey().toString();
                if ("x-opt-delivery-time".equals(string) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), deliveryTime);
                } else if ("x-opt-delivery-delay".equals(string) && entry.getValue() != null && (delay = ((Number)entry.getValue()).longValue()) > 0L) {
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), System.currentTimeMillis() + delay);
                }
                this.setProperty(jms, "JMS_AMQP_MA_" + string, entry.getValue());
            }
        }
        if ((ap = amqp.getApplicationProperties()) != null) {
            for (Map.Entry entry : ap.getValue().entrySet()) {
                this.setProperty(jms, entry.getKey().toString(), entry.getValue());
            }
        }
        if ((properties = amqp.getProperties()) != null) {
            Binary binary;
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getMessageId()));
            }
            if ((binary = properties.getUserId()) != null) {
                jms.setStringProperty("JMSXUserID", new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8));
            }
            if (properties.getTo() != null) {
                jms.setJMSDestination((Destination)new ServerDestination(properties.getTo()));
            }
            if (properties.getSubject() != null) {
                jms.setJMSType(properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                jms.setJMSReplyTo((Destination)new ServerDestination(properties.getReplyTo()));
            }
            if (properties.getCorrelationId() != null) {
                jms.setJMSCorrelationID(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getCorrelationId()));
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty("JMS_AMQP_ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty("JMS_AMQP_ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setJMSTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                jms.setStringProperty("_AMQ_GROUP_ID", properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                jms.setIntProperty("JMSXGroupSeq", properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty("JMS_AMQP_ReplyToGroupID", properties.getReplyToGroupId());
            }
            if (properties.getAbsoluteExpiryTime() != null) {
                jms.setJMSExpiration(properties.getAbsoluteExpiryTime().getTime());
            }
        }
        if (header != null && jms.getJMSExpiration() == 0L) {
            long l = 0L;
            if (header.getTtl() != null) {
                l = header.getTtl().longValue();
            }
            if (l == 0L) {
                jms.setJMSExpiration(0L);
            } else {
                jms.setJMSExpiration(System.currentTimeMillis() + l);
            }
        }
        if ((footer = amqp.getFooter()) != null) {
            for (Map.Entry entry : footer.getValue().entrySet()) {
                String key = entry.getKey().toString();
                this.setProperty(jms, "JMS_AMQP_FT_" + key, entry.getValue());
            }
        }
        return jms;
    }

    private void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        if (value instanceof UnsignedLong) {
            long v = ((UnsignedLong)value).longValue();
            msg.setLongProperty(key, v);
        } else if (value instanceof UnsignedInteger) {
            long v = ((UnsignedInteger)value).longValue();
            if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                msg.setIntProperty(key, (int)v);
            } else {
                msg.setLongProperty(key, v);
            }
        } else if (value instanceof UnsignedShort) {
            int v = ((UnsignedShort)value).intValue();
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                msg.setShortProperty(key, (short)v);
            } else {
                msg.setIntProperty(key, v);
            }
        } else if (value instanceof UnsignedByte) {
            short v = ((UnsignedByte)value).shortValue();
            if (-128 <= v && v <= 127) {
                msg.setByteProperty(key, (byte)v);
            } else {
                msg.setShortProperty(key, v);
            }
        } else if (value instanceof Symbol) {
            msg.setStringProperty(key, value.toString());
        } else if (value instanceof Decimal128) {
            msg.setDoubleProperty(key, ((Decimal128)value).doubleValue());
        } else if (value instanceof Decimal64) {
            msg.setDoubleProperty(key, ((Decimal64)value).doubleValue());
        } else if (value instanceof Decimal32) {
            msg.setFloatProperty(key, ((Decimal32)value).floatValue());
        } else if (value instanceof Binary) {
            msg.setStringProperty(key, value.toString());
        } else {
            msg.setObjectProperty(key, value);
        }
    }
}

