/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = -3504832582691232812L;
    private static final Logger LOG = LoggerFactory.getLogger(LogoutServlet.class);
    protected AuthenticationConfiguration authConfiguration;
    protected Redirector redirector = new Redirector();

    public void init() {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug("Logging out");
        this.addHeaders(response);
        request.logout();
        if (this.authConfiguration.isSpringSecurityEnabled()) {
            AuthSessionHelpers.clear(request, this.authConfiguration, false);
            this.redirector.doRedirect(request, response, "/");
        } else {
            AuthSessionHelpers.clear(request, this.authConfiguration, true);
            this.redirector.doRedirect(request, response, "/login");
        }
    }

    protected void addHeaders(HttpServletResponse response) {
        response.addHeader("Clear-Site-Data", "\"cache\", \"cookies\"");
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

