/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.web.MessageServletSupport;
import org.apache.activemq.web.NoDestinationSuppliedException;
import org.apache.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class MessageServlet
extends MessageServletSupport {
    private static final long serialVersionUID = 8737914695188481219L;
    private static final Log LOG = LogFactory.getLog(MessageServlet.class);
    private String readTimeoutParameter = "readTimeout";
    private long defaultReadTimeout = -1L;
    private long maximumReadTimeout = 20000L;
    private long requestTimeout = 1000L;
    private HashMap<String, WebClient> clients = new HashMap();

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String name = servletConfig.getInitParameter("defaultReadTimeout");
        if (name != null) {
            this.defaultReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumReadTimeout")) != null) {
            this.maximumReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("replyTimeout")) != null) {
            this.requestTimeout = this.asLong(name);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String action = request.getParameter("action");
            String clientId = request.getParameter("clientId");
            if (action != null && clientId != null && action.equals("unsubscribe")) {
                LOG.info((Object)("Unsubscribing client " + clientId));
                WebClient client = this.getWebClient(request);
                client.close();
                this.clients.remove(clientId);
                return;
            }
            WebClient client = this.getWebClient(request);
            String text = this.getPostedMessageBody(request);
            Destination destination = this.getDestination(client, request);
            if (destination == null) {
                throw new NoDestinationSuppliedException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending message to: " + destination + " with text: " + text));
            }
            boolean sync = this.isSync(request);
            TextMessage message = client.getSession().createTextMessage(text);
            if (sync) {
                String point = "activemq:" + ((ActiveMQDestination)destination).getPhysicalName().replace("//", "") + "?requestTimeout=" + this.requestTimeout;
                try {
                    String body = (String)client.getProducerTemplate().requestBody(point, (Object)text);
                    ActiveMQTextMessage answer = new ActiveMQTextMessage();
                    answer.setText(body);
                    this.writeMessageResponse(response.getWriter(), (Message)answer);
                }
                catch (Exception e) {
                    IOException ex = new IOException();
                    ex.initCause(e);
                    throw ex;
                }
            } else {
                this.appendParametersToMessage(request, message);
                boolean persistent = this.isSendPersistent(request);
                int priority = this.getSendPriority(request);
                long timeToLive = this.getSendTimeToLive(request);
                client.send(destination, (Message)message, persistent, priority, timeToLive);
            }
            response.setHeader("messageID", message.getJMSMessageID());
            response.setStatus(200);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMessages(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMessages(request, response);
    }

    protected void doMessages(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            WebClient client = this.getWebClient(request);
            Destination destination = this.getDestination(client, request);
            if (destination == null) {
                throw new NoDestinationSuppliedException();
            }
            MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination, request.getHeader(WebClient.selectorName));
            Message message = null;
            message = (Message)request.getAttribute("message");
            if (message != null) {
                this.writeResponse(request, response, message);
                return;
            }
            long timeout = this.getReadTimeout(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiving message(s) from: " + destination + " with timeout: " + timeout));
            }
            Continuation continuation = null;
            Listener listener = null;
            message = consumer.receive(10L);
            if (message == null) {
                continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isExpired()) {
                    response.setStatus(204);
                    return;
                }
                continuation.setTimeout(timeout);
                continuation.suspend();
                listener = (Listener)consumer.getAvailableListener();
                if (listener == null) {
                    listener = new Listener((MessageConsumer)consumer);
                    consumer.setAvailableListener((MessageAvailableListener)listener);
                }
                listener.setContinuation(continuation);
            }
            this.writeResponse(request, response, message);
        }
        catch (JMSException e) {
            throw new ServletException("Could not post JMS message: " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, Message message) throws IOException, JMSException {
        int messages = 0;
        try {
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            if (message == null) {
                response.setStatus(204);
            } else {
                response.setStatus(200);
                String type = this.getContentType(request);
                if (type != null) {
                    response.setContentType(type);
                }
                this.setResponseHeaders(response, message);
                this.writeMessageResponse(writer, message);
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received " + messages + " message(s)"));
            }
        }
    }

    protected void writeMessageResponse(PrintWriter writer, Message message) throws JMSException, IOException {
        if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            String txt = textMsg.getText();
            if (txt.startsWith("<?")) {
                txt = txt.substring(txt.indexOf("?>") + 2);
            }
            writer.print(txt);
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objectMsg = (ObjectMessage)message;
            Serializable object = objectMsg.getObject();
            writer.print(object.toString());
        }
    }

    protected boolean isRicoAjax(HttpServletRequest request) {
        String rico = request.getParameter("rico");
        return rico != null && rico.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebClient getWebClient(HttpServletRequest request) {
        String clientId = request.getParameter("clientId");
        if (clientId != null) {
            MessageServlet messageServlet = this;
            synchronized (messageServlet) {
                LOG.debug((Object)("Getting local client [" + clientId + "]"));
                WebClient client = this.clients.get(clientId);
                if (client == null) {
                    LOG.debug((Object)("Creating new client [" + clientId + "]"));
                    client = new WebClient();
                    this.clients.put(clientId, client);
                }
                return client;
            }
        }
        return WebClient.getWebClient(request);
    }

    protected String getContentType(HttpServletRequest request) {
        String value = request.getParameter("xml");
        if (value != null && "true".equalsIgnoreCase(value)) {
            return "text/xml";
        }
        return null;
    }

    protected void setResponseHeaders(HttpServletResponse response, Message message) throws JMSException {
        response.setHeader("destination", message.getJMSDestination().toString());
        response.setHeader("id", message.getJMSMessageID());
    }

    protected long getReadTimeout(HttpServletRequest request) {
        long answer = this.defaultReadTimeout;
        String name = request.getParameter(this.readTimeoutParameter);
        if (name != null) {
            answer = this.asLong(name);
        }
        if (answer < 0L || answer > this.maximumReadTimeout) {
            answer = this.maximumReadTimeout;
        }
        return answer;
    }

    private static class Listener
    implements MessageAvailableListener {
        MessageConsumer consumer;
        Continuation continuation;

        Listener(MessageConsumer consumer) {
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContinuation(Continuation continuation) {
            MessageConsumer messageConsumer = this.consumer;
            synchronized (messageConsumer) {
                this.continuation = continuation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessageAvailable(MessageConsumer consumer) {
            assert (this.consumer == consumer);
            MessageConsumer messageConsumer = this.consumer;
            synchronized (messageConsumer) {
                if (this.continuation != null) {
                    try {
                        Message message = consumer.receiveNoWait();
                        this.continuation.setAttribute("message", (Object)message);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error receiving message " + e), (Throwable)e);
                    }
                    this.continuation.resume();
                }
            }
        }
    }
}

