/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.jms.ConnectionFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class WebConsoleStarter
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog(WebConsoleStarter.class);

    public void contextInitialized(ServletContextEvent event) {
        LOG.debug((Object)"Initializing ActiveMQ WebConsole...");
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext context = this.createWebapplicationContext(servletContext);
        this.initializeWebClient(servletContext, context);
        LOG.info((Object)"ActiveMQ WebConsole initialized.");
    }

    private WebApplicationContext createWebapplicationContext(ServletContext servletContext) {
        String webconsoleType = System.getProperty("webconsole.type", "embedded");
        String configuration = "/WEB-INF/webconsole-" + webconsoleType + ".xml";
        XmlWebApplicationContext context = new XmlWebApplicationContext();
        context.setServletContext(servletContext);
        context.setConfigLocations(new String[]{configuration});
        context.refresh();
        context.start();
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        return context;
    }

    private void initializeWebClient(ServletContext servletContext, WebApplicationContext context) {
        ConnectionFactory connectionFactory = (ConnectionFactory)context.getBean("connectionFactory");
        servletContext.setAttribute("org.apache.activemq.connectionFactory", (Object)connectionFactory);
    }

    public void contextDestroyed(ServletContextEvent event) {
        XmlWebApplicationContext context = (XmlWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getServletContext());
        if (context != null) {
            context.stop();
            context.destroy();
        }
    }
}

