/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import java.io.IOException;
import java.util.UUID;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.state.ConnectionStateTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionStateTrackerTest {
    private final ActiveMQQueue queue = new ActiveMQQueue("Test");
    private ConnectionId testConnectionId;
    private SessionId testSessionId;
    private int connectionId = 0;
    private int sessionId = 0;
    private int consumerId = 0;

    @Before
    public void setUp() throws Exception {
        this.testConnectionId = this.createConnectionId();
        this.testSessionId = this.createSessionId(this.testConnectionId);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCacheSizeWithMessagePulls() throws IOException {
        ConsumerId consumer1 = this.createConsumerId(this.testSessionId);
        ConnectionStateTracker tracker = new ConnectionStateTracker();
        Assert.assertEquals((long)0L, (long)tracker.getCurrentCacheSize());
        MessagePull pullCommand = this.createPullCommand(consumer1);
        tracker.track((Command)pullCommand);
        Assert.assertEquals((long)0L, (long)tracker.getCurrentCacheSize());
        tracker.trackBack((Command)pullCommand);
        long currentSize = tracker.getCurrentCacheSize();
        Assert.assertTrue((currentSize > 0L ? 1 : 0) != 0);
        pullCommand = this.createPullCommand(consumer1);
        tracker.track((Command)pullCommand);
        tracker.trackBack((Command)pullCommand);
        Assert.assertEquals((long)currentSize, (long)tracker.getCurrentCacheSize());
    }

    private MessagePull createPullCommand(ConsumerId id) {
        MessagePull pullCommand = new MessagePull();
        pullCommand.setDestination((ActiveMQDestination)this.queue);
        pullCommand.setConsumerId(id);
        return pullCommand;
    }

    private ConnectionId createConnectionId() {
        ConnectionId id = new ConnectionId();
        id.setValue(UUID.randomUUID() + ":" + this.connectionId++);
        return id;
    }

    private SessionId createSessionId(ConnectionId connectionId) {
        return new SessionId(connectionId, (long)this.sessionId++);
    }

    private ConsumerId createConsumerId(SessionId sessionId) {
        return new ConsumerId(sessionId, (long)this.consumerId++);
    }
}

