/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.junit.Test;

public class ActiveMQSslConnectionFactoryTest {
    final String TRUST_STORE_FILE_NAME = "client.keystore";
    final String TRUST_STORE_PKCS12_FILE_NAME = "client-pkcs12.keystore";
    final String TRUST_STORE_DIRECTORY_NAME = "src/test/resources/ssl/";
    final String TRUST_STORE_RESOURCE_PREFIX = "ssl/";
    final String TRUST_STORE_PASSWORD = "password";
    final String SSL_TRANSPORT = "ssl://localhost:61617";
    final String FAILOVER_SSL_TRANSPORT = "failover:(ssl://localhost:61617)?maxReconnectAttempts=1";

    @Test(expected=ConnectException.class)
    public void validTrustStoreFileTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "src/test/resources/ssl/client.keystore");
    }

    @Test(expected=ConnectException.class)
    public void validTrustStoreURLTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", new File("src/test/resources/ssl/client.keystore").toURI().toString());
    }

    @Test(expected=ConnectException.class)
    public void validTrustStoreResourceTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "ssl/client.keystore");
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreFileTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "src/test/resources/ssl/client.keystore.dummy");
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreURLTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", new File("src/test/resources/ssl/client.keystore.dummy").toURI().toString());
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreResourceTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "ssl/client.keystore.dummy");
    }

    @Test(expected=IOException.class)
    public void validTrustStoreFileFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", "src/test/resources/ssl/client.keystore");
    }

    @Test(expected=IOException.class)
    public void validTrustStoreURLFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", new File("src/test/resources/ssl/client.keystore").toURI().toString());
    }

    @Test(expected=IOException.class)
    public void validTrustStoreResourceFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", "ssl/client.keystore");
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreFileFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", "src/test/resources/ssl/client.keystore.dummy");
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreURLFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", new File("src/test/resources/ssl/client.keystore.dummy").toURI().toString());
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreResourceFailoverTest() throws Throwable {
        this.executeTest("failover:(ssl://localhost:61617)?maxReconnectAttempts=1", "ssl/client.keystore.dummy");
    }

    @Test(expected=ConnectException.class)
    public void validPkcs12TrustStoreFileTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "src/test/resources/ssl/client-pkcs12.keystore", "pkcs12");
    }

    @Test(expected=ConnectException.class)
    public void validPkcs12TrustStoreURLTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", new File("src/test/resources/ssl/client-pkcs12.keystore").toURI().toString(), "pkcs12");
    }

    @Test(expected=ConnectException.class)
    public void validPkcs12TrustStoreResourceTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "ssl/client-pkcs12.keystore", "pkcs12");
    }

    @Test(expected=IOException.class)
    public void invalidTrustStoreTypeTest() throws Throwable {
        this.executeTest("ssl://localhost:61617", "ssl/client-pkcs12.keystore", "jks");
    }

    protected void executeTest(String transport, String name) throws Throwable {
        this.executeTest(transport, name, null);
    }

    protected ActiveMQSslConnectionFactory getFactory(String transport) {
        return new ActiveMQSslConnectionFactory(transport);
    }

    protected void executeTest(String transport, String name, String type) throws Throwable {
        try {
            ActiveMQSslConnectionFactory activeMQSslConnectionFactory = this.getFactory(transport);
            activeMQSslConnectionFactory.setTrustStoreType(type != null ? type : activeMQSslConnectionFactory.getTrustStoreType());
            activeMQSslConnectionFactory.setTrustStore(name);
            activeMQSslConnectionFactory.setTrustStorePassword("password");
            Connection connection = activeMQSslConnectionFactory.createConnection();
            connection.start();
            connection.stop();
        }
        catch (JMSException e) {
            e.getCause().printStackTrace();
            throw e.getCause();
        }
    }
}

