/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.tracer.SpanTreeVisitor;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.thrift.RemoteSpan;

public class SpanTree {
    final Map<Long, List<Long>> parentChildren = new HashMap<Long, List<Long>>();
    public final Map<Long, RemoteSpan> nodes = new HashMap<Long, RemoteSpan>();
    private final List<Long> rootSpans = new ArrayList<Long>();

    public void addNode(RemoteSpan span2) {
        this.nodes.put(span2.spanId, span2);
        if (span2.getParentIdsSize() == 0) {
            this.rootSpans.add(span2.spanId);
        }
        for (Long parentId : span2.getParentIds()) {
            this.parentChildren.computeIfAbsent(parentId, id -> new ArrayList()).add(span2.spanId);
        }
    }

    public Set<Long> visit(SpanTreeVisitor visitor) {
        HashSet<Long> visited = new HashSet<Long>();
        if (this.rootSpans.isEmpty()) {
            return visited;
        }
        RemoteSpan rootSpan = this.nodes.get(this.rootSpans.iterator().next());
        if (rootSpan == null) {
            return visited;
        }
        this.recurse(0, rootSpan, visitor, visited);
        return visited;
    }

    private void recurse(int level, RemoteSpan node, SpanTreeVisitor visitor, Set<Long> visited) {
        if (visited.contains(node.spanId)) {
            return;
        }
        visited.add(node.spanId);
        List<RemoteSpan> children = new ArrayList<RemoteSpan>();
        List<Long> childrenIds = this.parentChildren.get(node.spanId);
        if (childrenIds != null) {
            for (Long childId : childrenIds) {
                RemoteSpan child = this.nodes.get(childId);
                if (child == null) continue;
                children.add(child);
            }
        }
        children = TraceDump.sortByStart(children);
        visitor.visit(level, node);
        for (RemoteSpan child : children) {
            this.recurse(level + 1, child, visitor, visited);
        }
    }
}

