/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.accumulo.trace.instrument.Sampler;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.log4j.Logger;

public class TraceProxy {
    private static final Logger log = Logger.getLogger(TraceProxy.class);
    static final Sampler ALWAYS = new Sampler(){

        @Override
        public boolean next() {
            return true;
        }
    };

    public static <T> T trace(T instance) {
        return TraceProxy.trace(instance, ALWAYS);
    }

    public static <T> T trace(final T instance, final Sampler sampler) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                Span span2 = null;
                if (sampler.next()) {
                    span2 = Trace.on(method.getName());
                }
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause == null) {
                        log.error((Object)"Invocation exception during trace with null cause: ", (Throwable)ite);
                        throw new RuntimeException(ite);
                    }
                    throw cause;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (span2 != null) {
                        span2.stop();
                    }
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }
}

