/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.server.metrics.ThriftMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedProcessor
implements TProcessor {
    private static final Logger log = LoggerFactory.getLogger(TimedProcessor.class);
    private final TProcessor other;
    private final ThriftMetrics thriftMetrics;
    private long idleStart = 0L;

    public TimedProcessor(MetricsSystem metricsSystem, AccumuloConfiguration conf, TProcessor next, String serverName, String threadName) {
        this(metricsSystem, next, serverName, threadName);
    }

    public TimedProcessor(MetricsSystem metricsSystem, TProcessor next, String serverName, String threadName) {
        this.other = next;
        this.thriftMetrics = new ThriftMetrics(serverName, threadName);
        try {
            this.thriftMetrics.register(metricsSystem);
        }
        catch (Exception e) {
            log.error("Exception registering MBean with MBean Server", (Throwable)e);
        }
        this.idleStart = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(TProtocol in, TProtocol out) throws TException {
        long now = 0L;
        now = System.currentTimeMillis();
        this.thriftMetrics.addIdle(now - this.idleStart);
        try {
            boolean bl = this.other.process(in, out);
            return bl;
        }
        finally {
            this.idleStart = System.currentTimeMillis();
            this.thriftMetrics.addExecute(this.idleStart - now);
        }
    }
}

