/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableConfWatcher
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(TableConfWatcher.class);
    private final ServerContext context;
    private final String tablesPrefix;
    private ServerConfigurationFactory scf;

    TableConfWatcher(ServerContext context) {
        this.context = context;
        this.tablesPrefix = context.getZooKeeperRoot() + "/tables" + "/";
        this.scf = context.getServerConfFactory();
    }

    static String toString(WatchedEvent event) {
        return "{path=" + event.getPath() + ",state=" + event.getState() + ",type=" + event.getType() + "}";
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (log.isTraceEnabled()) {
            log.trace("WatchedEvent : {}", (Object)TableConfWatcher.toString(event));
        }
        String tableIdString = null;
        String key = null;
        if (path != null) {
            if (path.startsWith(this.tablesPrefix) && (tableIdString = path.substring(this.tablesPrefix.length())).contains("/")) {
                tableIdString = tableIdString.substring(0, tableIdString.indexOf(47));
                if (path.startsWith(this.tablesPrefix + tableIdString + "/conf" + "/")) {
                    key = path.substring((this.tablesPrefix + tableIdString + "/conf" + "/").length());
                }
            }
            if (tableIdString == null) {
                log.warn("Zookeeper told me about a path I was not watching: {}, event {}", (Object)path, (Object)TableConfWatcher.toString(event));
                return;
            }
        }
        TableId tableId = TableId.of(tableIdString);
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                if (log.isTraceEnabled()) {
                    log.trace("EventNodeDataChanged {}", (Object)event.getPath());
                }
                if (key == null) break;
                this.scf.getTableConfiguration(tableId).propertyChanged(key);
                break;
            }
            case NodeChildrenChanged: {
                this.scf.getTableConfiguration(tableId).propertiesChanged();
                break;
            }
            case NodeDeleted: {
                if (key != null) break;
                ServerConfigurationFactory.removeCachedTableConfiguration(this.context.getInstanceID(), tableId);
                break;
            }
            case None: {
                switch (event.getState()) {
                    case Expired: {
                        log.info("Zookeeper node event type None, state=expired. Expire all table observers");
                        ServerConfigurationFactory.expireAllTableObservers();
                        break block0;
                    }
                    case SyncConnected: {
                        break block0;
                    }
                    case Disconnected: {
                        break block0;
                    }
                }
                log.warn("EventNone event not handled {}", (Object)TableConfWatcher.toString(event));
                break;
            }
            case NodeCreated: {
                switch (event.getState()) {
                    case SyncConnected: {
                        break block0;
                    }
                }
                log.warn("Event NodeCreated event not handled {}", (Object)TableConfWatcher.toString(event));
                break;
            }
            default: {
                log.warn("Event not handled {}", (Object)TableConfWatcher.toString(event));
            }
        }
    }
}

