/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ServerInfo
implements ClientInfo {
    private SiteConfiguration siteConfig;
    private Configuration hadoopConf;
    private String instanceID;
    private String instanceName;
    private String zooKeepers;
    private int zooKeepersSessionTimeOut;
    private VolumeManager volumeManager;
    private ZooCache zooCache;

    ServerInfo(SiteConfiguration siteConfig, String instanceName, String zooKeepers, int zooKeepersSessionTimeOut) {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        this.siteConfig = siteConfig;
        this.hadoopConf = new Configuration();
        this.instanceName = instanceName;
        this.zooKeepers = zooKeepers;
        this.zooKeepersSessionTimeOut = zooKeepersSessionTimeOut;
        try {
            this.volumeManager = VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, this.hadoopConf);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.zooCache = new ZooCacheFactory().getZooCache(zooKeepers, zooKeepersSessionTimeOut);
        String instanceNamePath = "/accumulo/instances/" + instanceName;
        byte[] iidb = this.zooCache.get(instanceNamePath);
        if (iidb == null) {
            throw new RuntimeException("Instance name " + instanceName + " does not exist in zookeeper. Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
        }
        this.instanceID = new String(iidb, StandardCharsets.UTF_8);
        if (this.zooCache.get("/accumulo/" + this.instanceID) == null) {
            if (instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceID + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceID + " pointed to by the name " + instanceName + " does not exist in zookeeper");
        }
    }

    ServerInfo(SiteConfiguration config) {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        this.siteConfig = config;
        this.hadoopConf = new Configuration();
        try {
            this.volumeManager = VolumeManagerImpl.get((AccumuloConfiguration)this.siteConfig, this.hadoopConf);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Path instanceIdPath = ServerUtil.getAccumuloInstanceIdPath(this.volumeManager);
        this.instanceID = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)config, (Configuration)this.hadoopConf);
        this.zooKeepers = config.get(Property.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)config.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
        this.zooCache = new ZooCacheFactory().getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        this.instanceName = InstanceOperationsImpl.lookupInstanceName((ZooCache)this.zooCache, (UUID)UUID.fromString(this.instanceID));
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.siteConfig;
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getZooKeepers() {
        return this.zooKeepers;
    }

    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    public String getPrincipal() {
        return this.getCredentials().getPrincipal();
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.getCredentials().getToken();
    }

    public boolean saslEnabled() {
        return this.getSiteConfiguration().getBoolean(Property.INSTANCE_RPC_SASL_ENABLED);
    }

    public Properties getProperties() {
        Properties properties = ClientConfConverter.toProperties((AccumuloConfiguration)this.getSiteConfiguration());
        properties.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), this.getZooKeepers());
        properties.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), Integer.toString(this.getZooKeepersSessionTimeOut()));
        properties.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.getInstanceName());
        ClientProperty.setAuthenticationToken((Properties)properties, (AuthenticationToken)this.getAuthenticationToken());
        properties.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), this.getPrincipal());
        return properties;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Credentials getCredentials() {
        return SystemCredentials.get(this.getInstanceID(), this.getSiteConfiguration());
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }
}

