/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerInfo;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.security.UserGroupInformation;

public class ServerContext
extends ClientContext {
    private final ServerInfo info;
    private TableManager tableManager;
    private UniqueNameAllocator nameAllocator;
    private ZooReaderWriter zooReaderWriter;
    private ServerConfigurationFactory serverConfFactory = null;
    private AuthenticationTokenSecretManager secretManager;
    private CryptoService cryptoService = null;

    public ServerContext(SiteConfiguration siteConfig) {
        this(new ServerInfo(siteConfig));
    }

    public ServerContext(SiteConfiguration siteConfig, String instanceName, String zooKeepers, int zooKeepersSessionTimeOut) {
        this(new ServerInfo(siteConfig, instanceName, zooKeepers, zooKeepersSessionTimeOut));
    }

    public ServerContext(SiteConfiguration siteConfig, Properties clientProps) {
        this(siteConfig, ClientInfo.from((Properties)clientProps));
    }

    private ServerContext(SiteConfiguration siteConfig, ClientInfo info) {
        this(new ServerInfo(siteConfig, info.getInstanceName(), info.getZooKeepers(), info.getZooKeepersSessionTimeOut()));
    }

    private ServerContext(ServerInfo info) {
        super((ClientInfo)info, (AccumuloConfiguration)info.getSiteConfiguration());
        this.info = info;
        this.zooReaderWriter = new ZooReaderWriter((AccumuloConfiguration)info.getSiteConfiguration());
    }

    public synchronized void setupCrypto() throws CryptoService.CryptoException {
        if (this.cryptoService != null) {
            throw new CryptoService.CryptoException("Crypto Service " + this.cryptoService.getClass().getName() + " already exists and cannot be setup again");
        }
        AccumuloConfiguration acuConf = this.getConfiguration();
        this.cryptoService = CryptoServiceFactory.newInstance((AccumuloConfiguration)acuConf, (CryptoServiceFactory.ClassloaderType)CryptoServiceFactory.ClassloaderType.ACCUMULO);
    }

    public synchronized ServerConfigurationFactory getServerConfFactory() {
        if (this.serverConfFactory == null) {
            this.serverConfFactory = new ServerConfigurationFactory(this, this.info.getSiteConfiguration());
        }
        return this.serverConfFactory;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.getServerConfFactory().getSystemConfiguration();
    }

    void enforceKerberosLogin() {
        UserGroupInformation loginUser;
        SiteConfiguration conf = this.getServerConfFactory().getSiteConfiguration();
        String kerberosPrincipal = SecurityUtil.getServerPrincipal(conf.get(Property.GENERAL_KERBEROS_PRINCIPAL));
        try {
            loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get login user", e);
        }
        Preconditions.checkArgument((boolean)loginUser.hasKerberosCredentials(), (Object)"Server does not have Kerberos credentials");
        Preconditions.checkArgument((boolean)kerberosPrincipal.equals(loginUser.getUserName()), (Object)("Expected login user to be " + kerberosPrincipal + " but was " + loginUser.getUserName()));
    }

    public VolumeManager getVolumeManager() {
        return this.info.getVolumeManager();
    }

    public ZooReaderWriter getZooReaderWriter() {
        return this.zooReaderWriter;
    }

    public SslConnectionParams getServerSslParams() {
        return SslConnectionParams.forServer((AccumuloConfiguration)this.getConfiguration());
    }

    public SaslServerConnectionParams getSaslParams() {
        SiteConfiguration conf = this.getServerConfFactory().getSiteConfiguration();
        if (!conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return null;
        }
        return new SaslServerConnectionParams((AccumuloConfiguration)conf, this.getCredentials().getToken(), this.secretManager);
    }

    public ThriftServerType getThriftServerType() {
        AccumuloConfiguration conf = this.getConfiguration();
        if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SSL;
        }
        if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            if (conf.getBoolean(Property.INSTANCE_RPC_SSL_ENABLED)) {
                throw new IllegalStateException("Cannot create a Thrift server capable of both SASL and SSL");
            }
            return ThriftServerType.SASL;
        }
        String serverTypeName = conf.get(Property.GENERAL_RPC_SERVER_TYPE);
        return ThriftServerType.get(serverTypeName);
    }

    public void setSecretManager(AuthenticationTokenSecretManager secretManager) {
        this.secretManager = secretManager;
    }

    public AuthenticationTokenSecretManager getSecretManager() {
        return this.secretManager;
    }

    public synchronized TableManager getTableManager() {
        if (this.tableManager == null) {
            this.tableManager = new TableManager(this);
        }
        return this.tableManager;
    }

    public synchronized UniqueNameAllocator getUniqueNameAllocator() {
        if (this.nameAllocator == null) {
            this.nameAllocator = new UniqueNameAllocator(this);
        }
        return this.nameAllocator;
    }

    public CryptoService getCryptoService() {
        if (this.cryptoService == null) {
            throw new CryptoService.CryptoException("Crypto service not initialized.");
        }
        return this.cryptoService;
    }
}

