/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static final Logger renewalLog = LoggerFactory.getLogger((String)"KerberosTicketRenewal");

    public static void serverLogin(AccumuloConfiguration acuConf) {
        SecurityUtil.serverLogin(acuConf, acuConf.getPath(Property.GENERAL_KERBEROS_KEYTAB), acuConf.get(Property.GENERAL_KERBEROS_PRINCIPAL));
    }

    public static void serverLogin(AccumuloConfiguration acuConf, String keyTab, String principal) {
        if (keyTab == null || keyTab.length() == 0) {
            return;
        }
        if (principal == null || principal.length() == 0) {
            return;
        }
        if (SecurityUtil.login(principal, keyTab)) {
            try {
                SecurityUtil.startTicketRenewalThread(UserGroupInformation.getCurrentUser(), acuConf.getTimeInMillis(Property.GENERAL_KERBEROS_RENEWAL_PERIOD));
                return;
            }
            catch (IOException e) {
                log.error("Failed to obtain Kerberos user after successfully logging in", (Throwable)e);
            }
        }
        throw new RuntimeException("Failed to perform Kerberos login for " + principal + " using  " + keyTab);
    }

    static boolean login(String principalConfig, String keyTabPath) {
        try {
            String principalName = SecurityUtil.getServerPrincipal(principalConfig);
            if (keyTabPath != null && principalName != null && keyTabPath.length() != 0 && principalName.length() != 0) {
                log.info("Attempting to login with keytab as {}", (Object)principalName);
                UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keyTabPath);
                log.info("Succesfully logged in as user {}", (Object)principalName);
                return true;
            }
        }
        catch (IOException io) {
            log.error("Error logging in user " + principalConfig + " using keytab at " + keyTabPath, (Throwable)io);
        }
        return false;
    }

    public static String getServerPrincipal(String configuredPrincipal) {
        try {
            return org.apache.hadoop.security.SecurityUtil.getServerPrincipal((String)configuredPrincipal, (String)InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not convert configured server principal: " + configuredPrincipal, e);
        }
    }

    static void startTicketRenewalThread(final UserGroupInformation ugi, final long renewalPeriod) {
        Daemon t = new Daemon((Runnable)new LoggingRunnable(renewalLog, new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        renewalLog.debug("Invoking renewal attempt for Kerberos ticket");
                        ugi.checkTGTAndReloginFromKeytab();
                    }
                    catch (IOException e) {
                        renewalLog.error("Failed to renew Kerberos ticket", (Throwable)e);
                    }
                    try {
                        Thread.sleep(renewalPeriod);
                    }
                    catch (InterruptedException e) {
                        renewalLog.error("Renewal thread interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }));
        t.setName("Kerberos Ticket Renewal");
        t.start();
    }
}

