/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.UGIAssumingProcessor;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.security.UserImpersonation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCredentialsUpdatingInvocationHandler<I>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(TCredentialsUpdatingInvocationHandler.class);
    private static final ConcurrentHashMap<String, Class<? extends AuthenticationToken>> TOKEN_CLASS_CACHE = new ConcurrentHashMap();
    private final I instance;
    private final UserImpersonation impersonation;

    protected TCredentialsUpdatingInvocationHandler(I serverInstance, AccumuloConfiguration conf) {
        this.instance = serverInstance;
        this.impersonation = new UserImpersonation(conf);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.updateArgs(args);
        return this.invokeMethod(method, args);
    }

    protected void updateArgs(Object[] args) throws ThriftSecurityException {
        if (args == null || args.length < 2) {
            return;
        }
        TCredentials tcreds = null;
        if (args[0] != null && args[0] instanceof TCredentials) {
            tcreds = (TCredentials)args[0];
        } else if (args[1] != null && args[1] instanceof TCredentials) {
            tcreds = (TCredentials)args[1];
        }
        if (tcreds == null) {
            log.trace("Did not find a TCredentials object in the first two positions of the argument list, not updating principal");
            return;
        }
        Class<AuthenticationToken> tokenClass = this.getTokenClassFromName(tcreds.tokenClassName);
        String principal = UGIAssumingProcessor.rpcPrincipal();
        if (UGIAssumingProcessor.rpcMechanism() == SaslConnectionParams.SaslMechanism.DIGEST_MD5 && DelegationTokenImpl.class.isAssignableFrom(tokenClass)) {
            if (!principal.equals(tcreds.principal)) {
                log.warn("{} issued RPC with delegation token over DIGEST-MD5 as the Accumulo principal {}. Disallowing RPC", (Object)principal, (Object)tcreds.principal);
                throw new ThriftSecurityException("RPC principal did not match provided Accumulo principal", SecurityErrorCode.BAD_CREDENTIALS);
            }
            return;
        }
        if (!KerberosToken.class.isAssignableFrom(tokenClass) && !SystemCredentials.SystemToken.class.isAssignableFrom(tokenClass)) {
            log.debug("Will not update principal on authentication tokens other than KerberosToken. Received {}", tokenClass);
            throw new ThriftSecurityException("Did not receive a valid token", SecurityErrorCode.BAD_CREDENTIALS);
        }
        if (principal == null) {
            log.debug("Found KerberosToken in TCredentials, but did not receive principal from SASL processor");
            throw new ThriftSecurityException("Did not extract principal from Thrift SASL processor", SecurityErrorCode.BAD_CREDENTIALS);
        }
        if (!principal.equals(tcreds.principal)) {
            UserImpersonation.UsersWithHosts usersWithHosts = this.impersonation.get(principal);
            if (usersWithHosts == null) {
                this.principalMismatch(principal, tcreds.principal);
            }
            if (!usersWithHosts.getUsers().contains(tcreds.principal)) {
                this.principalMismatch(principal, tcreds.principal);
            }
            String clientAddr = TServerUtils.clientAddress.get();
            if (!usersWithHosts.getHosts().contains(clientAddr)) {
                String msg = "Principal in credentials object allowed mismatched Kerberos principals, but not on " + clientAddr;
                log.warn(msg);
                throw new ThriftSecurityException(msg, SecurityErrorCode.BAD_CREDENTIALS);
            }
        }
    }

    protected void principalMismatch(String expected, String actual) throws ThriftSecurityException {
        String msg = "Principal in credentials object should match kerberos principal. Expected '" + expected + "' but was '" + actual + "'";
        log.warn(msg);
        throw new ThriftSecurityException(msg, SecurityErrorCode.BAD_CREDENTIALS);
    }

    protected Class<? extends AuthenticationToken> getTokenClassFromName(String tokenClassName) {
        Class<? extends AuthenticationToken> current;
        Class<? extends AuthenticationToken> typedClz = TOKEN_CLASS_CACHE.get(tokenClassName);
        if (typedClz == null) {
            Class<?> clz;
            try {
                clz = Class.forName(tokenClassName);
            }
            catch (ClassNotFoundException e) {
                log.debug("Could not create class from token name: {}", (Object)tokenClassName, (Object)e);
                return null;
            }
            typedClz = clz.asSubclass(AuthenticationToken.class);
        }
        return (current = TOKEN_CLASS_CACHE.putIfAbsent(tokenClassName, typedClz)) != null ? current : typedClz;
    }

    private Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.instance, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }

    protected ConcurrentHashMap<String, Class<? extends AuthenticationToken>> getTokenCache() {
        return TOKEN_CLASS_CACHE;
    }
}

