/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class VolumeChooserEnvironmentImpl
implements VolumeChooserEnvironment {
    private final ServerContext context;
    private final VolumeChooserEnvironment.ChooserScope scope;
    private final TableId tableId;
    private final Text endRow;

    public VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.ChooserScope scope, ServerContext context) {
        this.context = context;
        this.scope = Objects.requireNonNull(scope);
        this.tableId = null;
        this.endRow = null;
    }

    public VolumeChooserEnvironmentImpl(TableId tableId, Text endRow, ServerContext context) {
        this.context = context;
        this.scope = VolumeChooserEnvironment.ChooserScope.TABLE;
        this.tableId = Objects.requireNonNull(tableId);
        this.endRow = endRow;
    }

    @Override
    public Text getEndRow() {
        if (this.scope != VolumeChooserEnvironment.ChooserScope.TABLE) {
            throw new IllegalStateException("Can only request end row for tables, not for " + (Object)((Object)this.scope));
        }
        return this.endRow;
    }

    @Override
    public boolean hasTableId() {
        return this.scope == VolumeChooserEnvironment.ChooserScope.TABLE;
    }

    @Override
    public TableId getTableId() {
        if (this.scope != VolumeChooserEnvironment.ChooserScope.TABLE) {
            throw new IllegalStateException("Can only request table id for tables, not for " + (Object)((Object)this.scope));
        }
        return this.tableId;
    }

    @Override
    public VolumeChooserEnvironment.ChooserScope getScope() {
        return this.scope;
    }

    @Override
    public ServiceEnvironment getServiceEnv() {
        return new ServiceEnvironmentImpl(this.context);
    }

    @Override
    public FileSystem getFileSystem(String option) {
        return this.context.getVolumeManager().getVolumeByPath(new Path(option)).getFileSystem();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VolumeChooserEnvironmentImpl)) {
            return false;
        }
        VolumeChooserEnvironmentImpl other = (VolumeChooserEnvironmentImpl)obj;
        return this.getScope() == other.getScope() && Objects.equals(this.getTableId(), other.getTableId());
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.scope) * 31 + Objects.hashCode(this.tableId);
    }
}

