/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooConfiguration
extends AccumuloConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZooConfiguration.class);
    private final ServerContext context;
    private final ZooCache propCache;
    private final AccumuloConfiguration parent;
    private final Map<String, String> fixedProps = Collections.synchronizedMap(new HashMap());
    private final String propPathPrefix;

    protected ZooConfiguration(ServerContext context, ZooCache propCache, AccumuloConfiguration parent) {
        this.context = context;
        this.propCache = propCache;
        this.parent = parent;
        this.propPathPrefix = context.getZooKeeperRoot() + "/config";
    }

    public void invalidateCache() {
        if (this.propCache != null) {
            this.propCache.clear();
        }
    }

    private String _get(Property property) {
        String key = property.getKey();
        String value = null;
        if (Property.isValidZooPropertyKey((String)key)) {
            value = this.getRaw(key);
        }
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using parent value for {} due to improperly formatted {}: {}", new Object[]{key, property.getType(), value});
            }
            value = this.parent.get(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Property property) {
        if (Property.isFixedZooPropertyKey((Property)property)) {
            String val = this.fixedProps.get(property.getKey());
            if (val != null) {
                return val;
            }
            Map<String, String> map = this.fixedProps;
            synchronized (map) {
                val = this._get(property);
                this.fixedProps.put(property.getKey(), val);
                return val;
            }
        }
        return this._get(property);
    }

    public boolean isPropertySet(Property prop, boolean cacheAndWatch) {
        if (this.fixedProps.containsKey(prop.getKey())) {
            return true;
        }
        if (cacheAndWatch) {
            if (this.getRaw(prop.getKey()) != null) {
                return true;
            }
        } else {
            ZooReaderWriter zr = this.context.getZooReaderWriter();
            String zPath = this.propPathPrefix + "/" + prop.getKey();
            try {
                if (zr.exists(zPath)) {
                    return true;
                }
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.parent.isPropertySet(prop, cacheAndWatch);
    }

    private String getRaw(String key) {
        String zPath = this.propPathPrefix + "/" + key;
        byte[] v = this.propCache.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, StandardCharsets.UTF_8);
        }
        return value;
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.parent.getProperties(props, filter);
        List children = this.propCache.getChildren(this.propPathPrefix);
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.test(child) || (value = this.getRaw(child)) == null) continue;
                props.put(child, value);
            }
        }
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.propCache.getUpdateCount();
    }
}

