/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishCreateTable;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.PopulateZookeeper;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.log4j.Logger;

class SetupPermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    public SetupPermissions(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance();
        for (TablePermission permission : TablePermission.values()) {
            try {
                security.grantTablePermission(SystemCredentials.get().toThrift(env.getInstance()), this.tableInfo.user, this.tableInfo.tableId, permission, this.tableInfo.namespaceId);
            }
            catch (ThriftSecurityException e) {
                Logger.getLogger(FinishCreateTable.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return new PopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        AuditedSecurityOperation.getInstance().deleteTable(SystemCredentials.get().toThrift(env.getInstance()), this.tableInfo.tableId, this.tableInfo.namespaceId);
    }
}

