/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CloneInfo;
import org.apache.accumulo.master.tableOps.CloneMetadata;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.tables.TableManager;

class CloneZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public CloneZookeeper(CloneInfo cloneInfo) throws NamespaceNotFoundException {
        this.cloneInfo = cloneInfo;
        Instance inst = HdfsZooInstance.getInstance();
        this.cloneInfo.namespaceId = Namespaces.getNamespaceId((Instance)inst, (String)((String)Tables.qualify((String)this.cloneInfo.tableName).getFirst()));
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        long val = 0L;
        if (!this.cloneInfo.srcNamespaceId.equals(this.cloneInfo.namespaceId)) {
            val += Utils.reserveNamespace(this.cloneInfo.namespaceId, tid, false, true, TableOperation.CLONE);
        }
        return val += Utils.reserveTable(this.cloneInfo.tableId, tid, true, false, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Utils.tableNameLock.lock();
        try {
            Instance instance = HdfsZooInstance.getInstance();
            Utils.checkTableDoesNotExist(instance, this.cloneInfo.tableName, this.cloneInfo.tableId, TableOperation.CLONE);
            TableManager.getInstance().cloneTable(this.cloneInfo.srcTableId, this.cloneInfo.tableId, this.cloneInfo.tableName, this.cloneInfo.namespaceId, this.cloneInfo.propertiesToSet, this.cloneInfo.propertiesToExclude, ZooUtil.NodeExistsPolicy.OVERWRITE);
            Tables.clearCache((Instance)instance);
            CloneMetadata cloneMetadata = new CloneMetadata(this.cloneInfo);
            return cloneMetadata;
        }
        finally {
            Utils.tableNameLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Instance instance = HdfsZooInstance.getInstance();
        TableManager.getInstance().removeTable(this.cloneInfo.tableId);
        if (!this.cloneInfo.srcNamespaceId.equals(this.cloneInfo.namespaceId)) {
            Utils.unreserveNamespace(this.cloneInfo.namespaceId, tid, false);
        }
        Utils.unreserveTable(this.cloneInfo.tableId, tid, true);
        Tables.clearCache((Instance)instance);
    }
}

