/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.FateServiceHandler;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.TraceRepo;
import org.apache.accumulo.master.tserverOps.ShutdownTServer;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.DeadServerList;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletServerState;
import org.apache.accumulo.server.util.DefaultMap;
import org.apache.accumulo.server.util.NamespacePropUtil;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;

class MasterClientServiceHandler
extends FateServiceHandler
implements MasterClientService.Iface {
    private static final Logger log = Master.log;
    private Instance instance;

    MasterClientServiceHandler(Master master) {
        super(master);
        this.instance = master.getInstance();
    }

    public long initiateFlush(TInfo tinfo, TCredentials c, String tableId) throws ThriftSecurityException, ThriftTableOperationException {
        byte[] fid;
        String namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        String zTablePath = "/accumulo/" + this.master.getConfiguration().getInstance().getInstanceID() + "/tables" + "/" + tableId + "/flush-id";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            fid = zoo.mutate(zTablePath, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) throws Exception {
                    long flushID = Long.parseLong(new String(currentValue));
                    return ("" + ++flushID).getBytes();
                }
            });
        }
        catch (KeeperException.NoNodeException nne) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
        }
        catch (Exception e) {
            Master.log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.OTHER, null);
        }
        return Long.parseLong(new String(fid));
    }

    public void waitForFlush(TInfo tinfo, TCredentials c, String tableId, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        if (endRow != null && startRow != null && ByteBufferUtil.toText((ByteBuffer)startRow).compareTo((BinaryComparable)ByteBufferUtil.toText((ByteBuffer)endRow)) >= 0) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        HashSet<TServerInstance> serversToFlush = new HashSet<TServerInstance>(this.master.tserverSet.getCurrentServers());
        for (long l = 0L; l < maxLoops; ++l) {
            for (TServerInstance instance : serversToFlush) {
                try {
                    LiveTServerSet.TServerConnection server = this.master.tserverSet.getConnection(instance);
                    if (server == null) continue;
                    server.flush(this.master.masterLock, tableId, ByteBufferUtil.toBytes((ByteBuffer)startRow), ByteBufferUtil.toBytes((ByteBuffer)endRow));
                }
                catch (TException ex) {
                    Master.log.error((Object)ex.toString());
                }
            }
            if (l == maxLoops - 1L) break;
            UtilWaitThread.sleep((long)50L);
            serversToFlush.clear();
            try {
                IsolatedScanner scanner;
                Connector conn = this.master.getConnector();
                if (tableId.equals("!0")) {
                    scanner = new IsolatedScanner(conn.createScanner("accumulo.root", Authorizations.EMPTY));
                    scanner.setRange(MetadataSchema.TabletsSection.getRange());
                } else {
                    scanner = new IsolatedScanner(conn.createScanner("accumulo.metadata", Authorizations.EMPTY));
                    scanner.setRange(new KeyExtent(new Text(tableId), null, ByteBufferUtil.toText((ByteBuffer)startRow)).toMetadataRange());
                }
                MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.fetch((ScannerBase)scanner);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                RowIterator ri = new RowIterator((Iterable)scanner);
                int tabletsToWaitFor = 0;
                int tabletCount = 0;
                Text ert = ByteBufferUtil.toText((ByteBuffer)endRow);
                while (ri.hasNext()) {
                    Iterator row = ri.next();
                    long tabletFlushID = -1L;
                    int logs = 0;
                    boolean online = false;
                    TServerInstance server = null;
                    Map.Entry entry = null;
                    while (row.hasNext()) {
                        entry = (Map.Entry)row.next();
                        Key key = (Key)entry.getKey();
                        if (MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) {
                            tabletFlushID = Long.parseLong(((Value)entry.getValue()).toString());
                        }
                        if (MetadataSchema.TabletsSection.LogColumnFamily.NAME.equals((Object)key.getColumnFamily())) {
                            ++logs;
                        }
                        if (!MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME.equals((Object)key.getColumnFamily())) continue;
                        online = true;
                        server = new TServerInstance((Value)entry.getValue(), key.getColumnQualifier());
                    }
                    if ((online || logs > 0) && tabletFlushID < flushID) {
                        ++tabletsToWaitFor;
                        if (server != null) {
                            serversToFlush.add(server);
                        }
                    }
                    ++tabletCount;
                    Text tabletEndRow = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getEndRow();
                    if (tabletEndRow != null && (ert == null || tabletEndRow.compareTo((BinaryComparable)ert) < 0)) continue;
                    break;
                }
                if (tabletsToWaitFor == 0) break;
                if (tabletCount != 0 || Tables.exists((Instance)this.master.getInstance(), (String)tableId)) continue;
                throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
            }
            catch (AccumuloException e) {
                Master.log.debug((Object)("Failed to scan accumulo.metadata table to wait for flush " + tableId), (Throwable)e);
                continue;
            }
            catch (TabletIterator.TabletDeletedException tde) {
                Master.log.debug((Object)("Failed to scan accumulo.metadata table to wait for flush " + tableId), (Throwable)tde);
                continue;
            }
            catch (AccumuloSecurityException e) {
                Master.log.warn((Object)e.getMessage(), (Throwable)e);
                throw new ThriftSecurityException();
            }
            catch (TableNotFoundException e) {
                Master.log.error((Object)e.getMessage(), (Throwable)e);
                throw new ThriftTableOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterMonitorInfo getMasterStats(TInfo info, TCredentials credentials) throws ThriftSecurityException {
        MasterMonitorInfo result = new MasterMonitorInfo();
        result.tServerInfo = new ArrayList();
        result.tableMap = new DefaultMap((Object)new TableInfo());
        for (Map.Entry<TServerInstance, TabletServerStatus> serverEntry : this.master.tserverStatus.entrySet()) {
            TabletServerStatus status = serverEntry.getValue();
            result.tServerInfo.add(status);
            for (Map.Entry entry : status.tableMap.entrySet()) {
                TableInfoUtil.add((TableInfo)((TableInfo)result.tableMap.get(entry.getKey())), (TableInfo)((TableInfo)entry.getValue()));
            }
        }
        result.badTServers = new HashMap();
        Set<TServerInstance> i$ = this.master.badServers;
        synchronized (i$) {
            for (TServerInstance bad : this.master.badServers.keySet()) {
                result.badTServers.put(bad.hostPort(), TabletServerState.UNRESPONSIVE.getId());
            }
        }
        result.state = this.master.getMasterState();
        result.goalState = this.master.getMasterGoalState();
        result.unassignedTablets = this.master.displayUnassigned();
        result.serversShuttingDown = new HashSet();
        i$ = this.master.serversToShutdown;
        synchronized (i$) {
            for (TServerInstance server : this.master.serversToShutdown) {
                result.serversShuttingDown.add(server.hostPort());
            }
        }
        DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)this.master.getInstance()) + "/dead/tservers");
        result.deadTabletServers = obit.getList();
        return result;
    }

    public void removeTableProperty(TInfo info, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, null, TableOperation.REMOVE_PROPERTY);
    }

    public void setTableProperty(TInfo info, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, value, TableOperation.SET_PROPERTY);
    }

    public void shutdown(TInfo info, TCredentials c, boolean stopTabletServers) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        if (stopTabletServers) {
            this.master.setMasterGoalState(MasterGoalState.CLEAN_STOP);
            EventCoordinator.Listener eventListener = this.master.nextEvent.getListener();
            do {
                eventListener.waitForEvents(1000L);
            } while (this.master.tserverSet.size() > 0);
        }
        this.master.setMasterState(MasterState.STOP);
    }

    public void shutdownTabletServer(TInfo info, TCredentials c, String tabletServer, boolean force) throws ThriftSecurityException {
        LiveTServerSet.TServerConnection server;
        this.master.security.canPerformSystemActions(c);
        TServerInstance doomed = this.master.tserverSet.find(tabletServer);
        if (!force && (server = this.master.tserverSet.getConnection(doomed)) == null) {
            Master.log.warn((Object)("No server found for name " + tabletServer));
            return;
        }
        long tid = this.master.fate.startTransaction();
        this.master.fate.seedTransaction(tid, new TraceRepo<Master>(new ShutdownTServer(doomed, force)), false);
        this.master.fate.waitForCompletion(tid);
        this.master.fate.delete(tid);
    }

    public void reportSplitExtent(TInfo info, TCredentials credentials, String serverName, TabletSplit split) {
        KeyExtent oldTablet = new KeyExtent(split.oldTablet);
        if (this.master.migrations.remove(oldTablet) != null) {
            Master.log.info((Object)("Canceled migration of " + split.oldTablet));
        }
        for (TServerInstance instance : this.master.tserverSet.getCurrentServers()) {
            if (!serverName.equals(instance.hostPort())) continue;
            this.master.nextEvent.event("%s reported split %s, %s", serverName, new KeyExtent((TKeyExtent)split.newTablets.get(0)), new KeyExtent((TKeyExtent)split.newTablets.get(1)));
            return;
        }
        Master.log.warn((Object)("Got a split from a server we don't recognize: " + serverName));
    }

    public void reportTabletStatus(TInfo info, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent ttablet) {
        KeyExtent tablet = new KeyExtent(ttablet);
        switch (status) {
            case LOAD_FAILURE: {
                Master.log.error((Object)(serverName + " reports assignment failed for tablet " + tablet));
                break;
            }
            case LOADED: {
                this.master.nextEvent.event("tablet %s was loaded on %s", tablet, serverName);
                break;
            }
            case UNLOADED: {
                this.master.nextEvent.event("tablet %s was unloaded from %s", tablet, serverName);
                break;
            }
            case UNLOAD_ERROR: {
                Master.log.error((Object)(serverName + " reports unload failed for tablet " + tablet));
                break;
            }
            case UNLOAD_FAILURE_NOT_SERVING: {
                if (!Master.log.isTraceEnabled()) break;
                Master.log.trace((Object)(serverName + " reports unload failed: not serving tablet, could be a split: " + tablet));
                break;
            }
            case CHOPPED: {
                this.master.nextEvent.event("tablet %s chopped", tablet);
            }
        }
    }

    public void setMasterGoalState(TInfo info, TCredentials c, MasterGoalState state) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        this.master.setMasterGoalState(state);
    }

    public void removeSystemProperty(TInfo info, TCredentials c, String property) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.removeSystemProperty((String)property);
            this.updatePlugins(property);
        }
        catch (Exception e) {
            Master.log.error((Object)"Problem removing config property in zookeeper", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSystemProperty(TInfo info, TCredentials c, String property, String value) throws ThriftSecurityException, TException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.setSystemProperty((String)property, (String)value);
            this.updatePlugins(property);
        }
        catch (Exception e) {
            Master.log.error((Object)"Problem setting config property in zookeeper", (Throwable)e);
            throw new TException(e.getMessage());
        }
    }

    public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, value, TableOperation.SET_PROPERTY);
    }

    public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, null, TableOperation.REMOVE_PROPERTY);
    }

    private void alterNamespaceProperty(TCredentials c, String namespace, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = null;
        namespaceId = ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)namespace, (TableOperation)op);
        if (!this.master.security.canAlterNamespace(c, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null) {
                NamespacePropUtil.removeNamespaceProperty((String)namespaceId, (String)property);
            } else {
                NamespacePropUtil.setNamespaceProperty((String)namespaceId, (String)property, (String)value);
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)namespaceId, (TableOperation)op);
            log.info((Object)"Error altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId, namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespaceproperty");
        }
        catch (Exception e) {
            log.error((Object)"Problem altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId, namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespace property");
        }
    }

    private void alterTableProperty(TCredentials c, String tableName, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId;
        String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)op);
        if (!this.master.security.canAlterTable(c, tableId, namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null || value.isEmpty()) {
                TablePropUtil.removeTableProperty((String)tableId, (String)property);
            } else if (!TablePropUtil.setTableProperty((String)tableId, (String)property, (String)value)) {
                throw new Exception("Invalid table property.");
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)op);
            log.info((Object)"Error altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
        catch (Exception e) {
            log.error((Object)"Problem altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
    }

    private void updatePlugins(String property) {
        if (property.equals(Property.MASTER_TABLET_BALANCER.getKey())) {
            TabletBalancer balancer = (TabletBalancer)ServerConfiguration.getSystemConfiguration((Instance)this.master.getInstance()).instantiateClassProperty(Property.MASTER_TABLET_BALANCER, TabletBalancer.class, (Object)new DefaultLoadBalancer());
            balancer.init(this.master.getConfiguration());
            this.master.tabletBalancer = balancer;
            log.info((Object)("tablet balancer changed to " + this.master.tabletBalancer.getClass().getName()));
        }
    }
}

