/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apacheextras.camel.component.hibernate.QueryFactory;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class QueryBuilder
implements QueryFactory {
    ParameterBuilder parameterBuilder;

    public static QueryBuilder query(final String query) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(Session session) {
                return session.createQuery(query);
            }

            public String toString() {
                return "Query: " + query + " params: " + this.getParameterDescription();
            }
        };
    }

    public static QueryBuilder nativeQuery(final String nativeQuery) {
        return new QueryBuilder(){

            @Override
            protected Query makeQueryObject(Session session) {
                return session.createSQLQuery(nativeQuery);
            }

            public String toString() {
                return "SQL: " + nativeQuery + this.getParameterDescription();
            }
        };
    }

    public QueryBuilder parameters(Object ... parameters) {
        return this.parameters(Arrays.asList(parameters));
    }

    public QueryBuilder parameters(final Collection parameters) {
        this.checkNoParametersConfigured();
        this.parameterBuilder = new ParameterBuilder(){

            @Override
            public void populateQuery(Session entityManager, Query query) {
                int counter = 0;
                for (Object parameter : parameters) {
                    query.setParameter(counter++, parameter);
                }
            }

            public String toString() {
                return "Parameters: " + parameters;
            }
        };
        return this;
    }

    public QueryBuilder parameters(final Map<String, Object> parameterMap) {
        this.checkNoParametersConfigured();
        this.parameterBuilder = new ParameterBuilder(){

            @Override
            public void populateQuery(Session entityManager, Query query) {
                Set entries = parameterMap.entrySet();
                for (Map.Entry entry : entries) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            }

            public String toString() {
                return "Parameters: " + parameterMap;
            }
        };
        return this;
    }

    protected void checkNoParametersConfigured() {
        if (this.parameterBuilder != null) {
            throw new IllegalArgumentException("Cannot add parameters to a QueryBuilder which already has parameters configured");
        }
    }

    @Override
    public Query createQuery(Session entityManager) {
        Query query = this.makeQueryObject(entityManager);
        this.populateQuery(entityManager, query);
        return query;
    }

    protected String getParameterDescription() {
        if (this.parameterBuilder == null) {
            return "";
        }
        return " " + this.parameterBuilder.toString();
    }

    protected void populateQuery(Session entityManager, Query query) {
        if (this.parameterBuilder != null) {
            this.parameterBuilder.populateQuery(entityManager, query);
        }
    }

    protected abstract Query makeQueryObject(Session var1);

    protected static abstract class ParameterBuilder {
        protected ParameterBuilder() {
        }

        public abstract void populateQuery(Session var1, Query var2);
    }
}

