/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import java.util.Iterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultProducer;
import org.apacheextras.camel.component.hibernate.HibernateEndpoint;
import org.apacheextras.camel.component.hibernate.TransactionCallback;
import org.apacheextras.camel.component.hibernate.TransactionStrategy;
import org.hibernate.Session;

public class HibernateProducer
extends DefaultProducer {
    private final TransactionStrategy template;
    private final HibernateEndpoint endpoint;
    private final Expression expression;

    public HibernateProducer(HibernateEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.expression = expression;
        this.template = endpoint.getTransactionStrategy();
    }

    public void process(Exchange exchange) {
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.template.execute(new TransactionCallback<Object>(){

                @Override
                public Object doInTransaction(Session session) {
                    Iterator iter = ObjectConverter.iterator((Object)values);
                    while (iter.hasNext()) {
                        Object value = iter.next();
                        session.persist(value);
                    }
                    if (HibernateProducer.this.endpoint.isFlushOnSend()) {
                        session.flush();
                    }
                    return null;
                }
            });
        }
        exchange.setProperty("CamelHibernateValue", values);
    }
}

