/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apacheextras.camel.component.hibernate.HibernateComponent;
import org.apacheextras.camel.component.hibernate.HibernateConsumer;
import org.apacheextras.camel.component.hibernate.HibernateProducer;
import org.apacheextras.camel.component.hibernate.TransactionStrategy;
import org.hibernate.SessionFactory;

public class HibernateEndpoint
extends ScheduledPollEndpoint {
    private SessionFactory sessionFactory;
    private TransactionStrategy transactionStrategy;
    private Expression producerExpression;
    private int maximumResults = -1;
    private Class<?> entityType;
    private boolean consumeDelete = true;
    private boolean consumeLockEntity = true;
    private boolean flushOnSend = true;
    private boolean deleteFirstOnConsume = true;

    public HibernateEndpoint(String uri, HibernateComponent component) {
        super(uri, (Component)component);
        this.sessionFactory = component.getSessionFactory();
        this.transactionStrategy = component.getTransactionStrategy();
    }

    public Producer createProducer() throws Exception {
        return new HibernateProducer(this, this.getProducerExpression());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HibernateConsumer consumer = new HibernateConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    public void setProducerExpression(Expression producerExpression) {
        this.producerExpression = producerExpression;
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        this.maximumResults = maximumResults;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public boolean isConsumeDelete() {
        return this.consumeDelete;
    }

    public void setConsumeDelete(boolean consumeDelete) {
        this.consumeDelete = consumeDelete;
    }

    public boolean isConsumeLockEntity() {
        return this.consumeLockEntity;
    }

    public void setConsumeLockEntity(boolean consumeLockEntity) {
        this.consumeLockEntity = consumeLockEntity;
    }

    public boolean isFlushOnSend() {
        return this.flushOnSend;
    }

    public void setFlushOnSend(boolean flushOnSend) {
        this.flushOnSend = flushOnSend;
    }

    public boolean isDeleteFirstOnConsume() {
        return this.deleteFirstOnConsume;
    }

    public void setDeleteFirstOnConsume(boolean deleteFirstOnConsume) {
        this.deleteFirstOnConsume = deleteFirstOnConsume;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public TransactionStrategy getTransactionStrategy() {
        return this.transactionStrategy;
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    protected Expression createProducerExpression() {
        final Class<?> type = this.getEntityType();
        if (type == null) {
            return ExpressionBuilder.bodyExpression();
        }
        return new Expression(){

            public Object evaluate(Exchange exchange, Class asType) {
                Object answer = exchange.getIn().getBody(type);
                if (answer == null) {
                    Object defaultValue = exchange.getIn().getBody();
                    if (defaultValue != null) {
                        throw ObjectHelper.wrapRuntimeCamelException((Throwable)new NoTypeConversionAvailableException(defaultValue, type));
                    }
                    answer = exchange.getContext().getInjector().newInstance(type);
                }
                return answer;
            }
        };
    }
}

