/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apacheextras.camel.component.hibernate.Consumed;
import org.apacheextras.camel.component.hibernate.DeleteHandler;
import org.apacheextras.camel.component.hibernate.HibernateEndpoint;
import org.apacheextras.camel.component.hibernate.QueryBuilder;
import org.apacheextras.camel.component.hibernate.QueryFactory;
import org.apacheextras.camel.component.hibernate.TransactionCallback;
import org.apacheextras.camel.component.hibernate.TransactionStrategy;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateConsumer
extends ScheduledPollConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(HibernateConsumer.class);
    private final HibernateEndpoint endpoint;
    private final TransactionStrategy transactionStrategy;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;

    public HibernateConsumer(HibernateEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.transactionStrategy = endpoint.getTransactionStrategy();
    }

    protected int poll() throws Exception {
        this.transactionStrategy.execute(new TransactionCallback(){

            public Object doInTransaction(Session session) {
                Query query = HibernateConsumer.this.getQueryFactory().createQuery(session);
                HibernateConsumer.this.configureParameters(query);
                List results = query.list();
                for (Object result : results) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing new entity: " + result);
                    }
                    if (HibernateConsumer.this.endpoint.isDeleteFirstOnConsume()) {
                        HibernateConsumer.this.getDeleteHandler().deleteObject(session, result);
                        HibernateConsumer.this.processResult(result);
                        continue;
                    }
                    if (!HibernateConsumer.this.lockEntity(result, session)) continue;
                    HibernateConsumer.this.processResult(result);
                    HibernateConsumer.this.getDeleteHandler().deleteObject(session, result);
                }
                session.flush();
                return results.size();
            }
        });
        return 0;
    }

    protected void processResult(Object result) {
        Exchange exchange = this.createExchange(result);
        try {
            this.getProcessor().process(exchange);
            if (exchange.isFailed()) {
                throw new RuntimeCamelException((Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            LOG.error("Failed: " + e, (Throwable)e);
            if (e instanceof RuntimeCamelException) {
                throw (RuntimeCamelException)e;
            }
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public HibernateEndpoint getEndpoint() {
        return this.endpoint;
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    protected boolean lockEntity(Object entity, Session session) {
        if (!this.getEndpoint().isConsumeDelete() || !this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquiring exclusive lock on entity: " + entity);
            }
            session.buildLockRequest(LockOptions.UPGRADE).setLockMode(LockMode.PESSIMISTIC_WRITE).setTimeOut(60000).lock(entity);
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to achieve lock on entity: " + entity + ". Reason: " + e, (Throwable)e);
            }
            return false;
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            throw new IllegalArgumentException("named queries are not yet implemented!");
        }
        if (this.nativeQuery != null) {
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.endpoint.getEntityType();
        if (entityType == null) {
            return null;
        }
        return QueryBuilder.query("select x from " + entityType.getName() + " x");
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = (Method)methods.get(0);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(Session session, Object entityBean) {
                        ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return new DeleteHandler<Object>(){

                @Override
                public void deleteObject(Session session, Object entityBean) {
                    session.delete(entityBean);
                }
            };
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(Session session, Object entityBean) {
            }
        };
    }

    protected void configureParameters(Query query) {
        int maxResults = this.endpoint.getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
    }

    protected Exchange createExchange(Object result) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody(result);
        return exchange;
    }
}

