/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apacheextras.camel.component.hibernate.DefaultTransactionStrategy;
import org.apacheextras.camel.component.hibernate.HibernateEndpoint;
import org.apacheextras.camel.component.hibernate.TransactionStrategy;
import org.hibernate.SessionFactory;

public class HibernateComponent
extends DefaultComponent {
    private SessionFactory sessionFactory;
    private TransactionStrategy transactionStrategy;

    protected void doStart() throws Exception {
        super.doStart();
        if (this.transactionStrategy == null) {
            this.transactionStrategy = this.resolveTransactionStrategy();
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public TransactionStrategy getTransactionStrategy() {
        return this.transactionStrategy;
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    private TransactionStrategy resolveTransactionStrategy() {
        return new DefaultTransactionStrategy(this.sessionFactory);
    }

    protected Endpoint createEndpoint(String uri, String path, Map options) throws Exception {
        Class type;
        HibernateEndpoint endpoint = new HibernateEndpoint(uri, this);
        if (path != null && (type = ObjectHelper.loadClass((String)path)) != null) {
            endpoint.setEntityType(type);
        }
        return endpoint;
    }
}

