/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.hibernate;

import org.apache.camel.support.ServiceSupport;
import org.apacheextras.camel.component.hibernate.TransactionCallback;
import org.apacheextras.camel.component.hibernate.TransactionStrategy;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class DefaultTransactionStrategy
extends ServiceSupport
implements TransactionStrategy {
    private final SessionFactory sessionFactory;

    public DefaultTransactionStrategy(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public <T> T execute(TransactionCallback<T> callback) {
        Session session = this.sessionFactory.getCurrentSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            T result = callback.doInTransaction(session);
            transaction.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

