/*
 * Decompiled with CFR 0.152.
 */
package org.antora.gradle;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.NodePlugin;
import com.github.gradle.node.npm.task.NpmInstallTask;
import com.github.gradle.node.npm.task.NpmSetupTask;
import com.github.gradle.node.util.PlatformHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.antora.gradle.AntoraExtension;
import org.antora.gradle.AntoraPlaybookProvider;
import org.antora.gradle.AntoraTask;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class AntoraPlugin
implements Plugin<Project> {
    private static final String ANTORA_CLI_PACKAGE_NAME = "@antora/cli";
    private static final String ANTORA_COMMAND_NAME = "antora";
    private static final String ANTORA_EXTENSION_NAME = "antora";
    private static final String ANTORA_PACKAGE_NAME = "antora";
    private static final String DEFAULT_ANTORA_TASK_NAME = "antora";
    private static final String NPM_CI_OR_INSTALL_TASK_NAME = "npmCiOrInstall";
    private static final String PACKAGE_FILE = "package.json";
    private static final String PACKAGE_LOCK_FILE = "package-lock.json";

    public void apply(Project project) {
        StartParameter startParams = project.getGradle().getStartParameter();
        boolean showStacktrace = startParams.getShowStacktrace().name().startsWith("ALWAYS");
        AntoraExtension antora = (AntoraExtension)project.getExtensions().create("antora", AntoraExtension.class, new Object[0]);
        if (showStacktrace) {
            antora.getOptions().convention(List.of("--stacktrace"));
        }
        project.afterEvaluate(p -> AntoraPlugin.setNodeVersion(p, NodeExtension.get((Project)p), startParams.isOffline()));
        project.getPlugins().apply(NodePlugin.class);
        NodeExtension.get((Project)project).getDownload().convention((Object)true);
        TaskProvider npmCiOrInstall = AntoraPlugin.packageFileExistsWithDependencies(project.file((Object)PACKAGE_FILE)) ? project.getTasks().register(NPM_CI_OR_INSTALL_TASK_NAME, NpmInstallTask.class, npmInstallTask -> {
            npmInstallTask.setDescription("Install node packages from package-lock.json, if present, otherwise from package.json.");
            HashMap<String, String> environment = new HashMap<String, String>();
            environment.put("npm_config_omit", "optional");
            environment.put("npm_config_update_notifier", "false");
            npmInstallTask.getEnvironment().set(environment);
            npmInstallTask.getNpmCommand().set(project.file((Object)PACKAGE_LOCK_FILE).exists() ? List.of("ci") : List.of("i", "--no-package-lock"));
        }) : null;
        project.getTasks().register("antora", AntoraTask.class, antoraTask -> {
            antoraTask.setDescription("Runs Antora to generate a documentation site described by the playbook file.");
            Provider environment = NodeExtension.get((Project)project).getNpmWorkDir().map(dir -> {
                HashMap<String, String> env = new HashMap<String, String>((Map)antora.getEnvironment().get());
                String isTTY = System.getenv("IS_TTY");
                if (isTTY == null) {
                    isTTY = "true";
                    env.put("IS_TTY", "true");
                }
                if ("true".equals(isTTY) && System.getenv("FORCE_COLOR") == null && !ConsoleOutput.Plain.equals((Object)project.getGradle().getStartParameter().getConsoleOutput())) {
                    env.put("FORCE_COLOR", "true");
                }
                env.put("NODE_OPTIONS", "--no-global-search-paths");
                env.put("npm_config_cache", dir.getAsFile().getPath());
                env.put("npm_config_lockfile_version", "3");
                env.put("npm_config_omit", "optional");
                env.put("npm_config_update_notifier", "false");
                return env;
            });
            Provider command = project.provider(() -> "--yes");
            Provider args = antora.getPlaybook().map(file -> {
                if (new File(System.getProperty("user.home"), "node_modules").exists()) {
                    project.getLogger().warn("Detected the existence of $HOME/node_modules. This directory is not compatible with this plugin. Please remove it.");
                }
                String playbookPath = project.relativePath(antoraTask.getPlaybook() == null ? file : antoraTask.getPlaybook());
                File playbookFile = project.file((Object)playbookPath);
                if (AntoraPlugin.retrievePlaybookFile(project, antora.getPlaybookProvider(), playbookFile) && npmCiOrInstall == null) {
                    AntoraPlugin.registerAdditionalDependencies(antora, playbookFile);
                }
                ArrayList<String> arguments = new ArrayList<String>();
                if (npmCiOrInstall == null) {
                    arguments.addAll(List.of("--package", AntoraPlugin.antoraPackageSpec(antora)));
                    ((Map)antora.getPackages().get()).forEach((name, version) -> arguments.addAll(List.of("--package", AntoraPlugin.packageSpec(name, version))));
                } else if (!project.file((Object)("node_modules/.bin/" + (new PlatformHelper().isWindows() ? "antora.cmd" : "antora"))).exists()) {
                    arguments.addAll(List.of("--package", AntoraPlugin.antoraCliPackageSpec(antora)));
                }
                arguments.add("antora");
                arguments.addAll((Collection)antora.getOptions().map(list -> {
                    List<String> antoraExtensionOptionValues;
                    String uiBundleUrlOptionValue;
                    ArrayList<String> merged = new ArrayList<String>((Collection<String>)list);
                    if (showStacktrace && !merged.contains("--stacktrace")) {
                        merged.add("--stacktrace");
                    }
                    if ((uiBundleUrlOptionValue = antoraTask.getUiBundleUrl()) != null) {
                        int idx = merged.indexOf("--ui-bundle-url");
                        if (idx >= 0) {
                            merged.set(idx + 1, uiBundleUrlOptionValue);
                        } else {
                            merged.addAll(List.of("--ui-bundle-url", uiBundleUrlOptionValue));
                        }
                    }
                    if ((antoraExtensionOptionValues = antoraTask.getAntoraExtensions()) != null) {
                        antoraExtensionOptionValues.forEach(v -> merged.addAll(List.of("--extension", v)));
                    }
                    return merged;
                }).get());
                arguments.add(playbookPath);
                return arguments;
            });
            antoraTask.getEnvironment().set(environment);
            antoraTask.getCommand().set(command);
            antoraTask.getArgs().set(args);
            if (npmCiOrInstall != null) {
                antoraTask.dependsOn(new Object[]{npmCiOrInstall});
            }
        });
    }

    private static String antoraCliPackageSpec(AntoraExtension antora) {
        return ANTORA_CLI_PACKAGE_NAME + AntoraPlugin.antoraVersionQualifier(antora);
    }

    private static String antoraPackageSpec(AntoraExtension antora) {
        return "antora" + AntoraPlugin.antoraVersionQualifier(antora);
    }

    private static String antoraVersionQualifier(AntoraExtension antora) {
        return (String)antora.getVersion().map(v -> "@" + v).getOrElse((Object)"");
    }

    private static void download(URL url, File toFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());
             FileOutputStream out = new FileOutputStream(toFile);){
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = in.read(buffer, 0, 1024)) != -1) {
                out.write(buffer, 0, count);
            }
        }
    }

    private static boolean isOlderThanOneDay(long lastModified) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(10, -24);
        Date dayOld = cal.getTime();
        return new Date(lastModified).before(dayOld);
    }

    private static boolean packageFileExistsWithDependencies(File packageJson) {
        boolean bl;
        if (!packageJson.exists()) {
            return false;
        }
        FileReader reader = new FileReader(packageJson);
        try {
            JsonObject pkg = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            bl = pkg.has("dependencies") && pkg.getAsJsonObject("dependencies").size() > 0 || pkg.has("devDependencies") && pkg.getAsJsonObject("devDependencies").size() > 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    private static String packageSpec(String name, String version) {
        return version == null || version.isEmpty() ? name : name + "@" + version;
    }

    private static void registerAdditionalDependencies(AntoraExtension antora, File playbookFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(playbookFile));){
            MapProperty<String, String> packages = antora.getPackages();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("# PACKAGES ")) continue;
                for (String spec : line.substring(11).split(" +")) {
                    String versionSpec;
                    String[] parts = spec.split("(?!^)[@:]");
                    String name = parts[0];
                    String string = versionSpec = parts.length > 1 ? parts[1] : null;
                    if ("antora".equals(name)) {
                        if (antora.getVersion().isPresent()) continue;
                        antora.getVersion().set((Object)versionSpec);
                        continue;
                    }
                    if (packages.getting((Object)name).isPresent()) continue;
                    packages.put((Object)name, (Object)(versionSpec == null ? "" : versionSpec));
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean retrievePlaybookFile(Project project, AntoraPlaybookProvider provider, File toFile) {
        if (!provider.isPresent()) {
            return false;
        }
        if (toFile.exists()) {
            return true;
        }
        if (((Boolean)provider.getCheckLocalBranch().get()).booleanValue()) {
            try {
                AntoraPlugin.sideload(project, provider.getRevPath(), toFile);
                return true;
            }
            catch (Exception ex) {
                toFile.delete();
            }
        }
        try {
            AntoraPlugin.download(provider.getDownloadUrl(), toFile);
            return true;
        }
        catch (IOException ex) {
            toFile.delete();
            throw new InvalidUserDataException("Failed to download playbook from specified provider " + provider + ".", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setNodeVersion(Project project, NodeExtension node, boolean offline) {
        if (!((Boolean)node.getDownload().get()).booleanValue()) {
            return;
        }
        Property versionProperty = node.getVersion();
        try {
            Optional<JsonObject> release;
            String nodeVersion;
            String originalNodeVersion = (String)versionProperty.get();
            versionProperty.convention((Object)null);
            if (versionProperty.isPresent()) {
                nodeVersion = originalNodeVersion;
                if (!nodeVersion.equals("lts") && !nodeVersion.equals("latest") && nodeVersion.split("[.]").length > 2) {
                    return;
                }
                versionProperty.set((Object)null);
            } else if (System.getProperty("org.gradle.test.worker") == null) {
                nodeVersion = "lts";
            } else {
                return;
            }
            File dists = new File(((File)node.getWorkDir().getAsFile().get()).getPath() + ".json");
            if (!dists.getParentFile().exists()) {
                dists.getParentFile().mkdirs();
            }
            if (offline) {
                if (!dists.exists()) {
                    project.getLogger().warn("No cached version of Node.js release data to resolve Node.js version in offline mode. Reverting to default version.");
                }
            } else if (!dists.exists() || AntoraPlugin.isOlderThanOneDay(dists.lastModified())) {
                AntoraPlugin.download(new URL((String)node.getDistBaseUrl().get() + "/index.json"), dists);
            }
            JsonArray releases = JsonParser.parseString((String)Files.readString(dists.toPath())).getAsJsonArray();
            Stream<JsonObject> releasesStream = StreamSupport.stream(releases.spliterator(), false).map(JsonElement::getAsJsonObject).map(it -> {
                String rawVersion = it.get("version").getAsString();
                if (rawVersion.startsWith("v")) {
                    it.remove("version");
                    it.addProperty("version", rawVersion.substring(1));
                }
                return it;
            });
            if (nodeVersion.equals("latest")) {
                release = releasesStream.findFirst();
            } else if (nodeVersion.equals("lts")) {
                release = releasesStream.filter(it -> it.getAsJsonPrimitive("lts").isString()).findFirst();
            } else {
                String prefix = nodeVersion + ".";
                release = releasesStream.filter(it -> it.get("version").getAsString().startsWith(prefix)).findFirst();
            }
            if (!release.isPresent()) {
                return;
            }
            versionProperty.set((Object)release.get().get("version").getAsString());
            if (((String)node.getNpmVersion().get()).equals(release.get().get("npm").getAsString())) {
                node.getNpmVersion().set((Object)null);
            }
        }
        catch (IOException npmSetupTask) {
        }
        finally {
            versionProperty.convention((Object)"16.14.2");
            TaskProvider npmSetupTask = project.getTasks().named("npmSetup", NpmSetupTask.class);
            if (npmSetupTask.isPresent() && ((NpmSetupTask)npmSetupTask.get()).isTaskEnabled()) {
                ((NpmSetupTask)npmSetupTask.get()).getArgs().convention(List.of("--no-audit", "--no-fund"));
            }
        }
    }

    private static void sideload(Project project, String revPath, File toFile) throws IOException {
        File gitdir = new File(project.getRootDir(), ".git");
        if (gitdir.isFile()) {
            File worktreeGitdir = new File(Files.readAllLines(gitdir.toPath()).get(0).substring(8));
            String commondir = Files.readAllLines(new File(worktreeGitdir, "commondir").toPath()).get(0);
            gitdir = new File(worktreeGitdir, commondir).getCanonicalFile();
        }
        try (FileOutputStream os = new FileOutputStream(toFile);){
            Repository repo = ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitdir)).setMustExist(true)).build();
            repo.newObjectReader().open((AnyObjectId)repo.resolve(revPath)).copyTo((OutputStream)os);
        }
    }
}

