/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class JUnitCodeGen {
    public GrammarInfo grammarInfo;
    public Map<String, String> ruleWithReturn;
    private static final Handler console = new ConsoleHandler();
    private static final Logger logger = Logger.getLogger(JUnitCodeGen.class.getName());

    public JUnitCodeGen(GrammarInfo grammarInfo) throws ClassNotFoundException {
        Method[] methods;
        this.grammarInfo = grammarInfo;
        this.ruleWithReturn = new HashMap<String, String>();
        Class<?> c = grammarInfo.getHeader() != null ? Class.forName(grammarInfo.getHeader() + "." + grammarInfo.getGrammarName() + "Parser") : Class.forName(grammarInfo.getGrammarName() + "Parser");
        for (Method method : methods = c.getDeclaredMethods()) {
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    public void compile() throws IOException {
        String junitFileName = this.grammarInfo.getTreeGrammarName() != null ? "Test" + this.grammarInfo.getTreeGrammarName() : "Test" + this.grammarInfo.getGrammarName();
        String lexerName = this.grammarInfo.getGrammarName() + "Lexer";
        String parserName = this.grammarInfo.getGrammarName() + "Parser";
        CommonGroupLoader loader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        StringBuffer buf = this.compileToBuffer(junitFileName, lexerName, parserName);
        this.writeTestFile(".", junitFileName + ".java", buf.toString());
    }

    public StringBuffer compileToBuffer(String className, String lexerName, String parserName) {
        StringTemplateGroup group = StringTemplateGroup.loadGroup((String)"junit");
        StringBuffer buf = new StringBuffer();
        buf.append(this.genClassHeader(group, className, lexerName, parserName));
        buf.append(this.genTestRuleMethods(group));
        buf.append("\n\n}");
        return buf;
    }

    protected String genClassHeader(StringTemplateGroup group, String junitFileName, String lexerName, String parserName) {
        StringTemplate classHeaderST = group.getInstanceOf("classHeader");
        if (this.grammarInfo.getHeader() != null) {
            classHeaderST.setAttribute("header", (Object)("package " + this.grammarInfo.getHeader() + ";"));
        }
        classHeaderST.setAttribute("junitFileName", (Object)junitFileName);
        String lexerPath = null;
        String parserPath = null;
        String treeParserPath = null;
        String packagePath = null;
        boolean isTreeGrammar = false;
        boolean hasPackage = false;
        if (this.grammarInfo.getHeader() != null) {
            hasPackage = true;
            packagePath = "./" + this.grammarInfo.getHeader().replace('.', '/');
            lexerPath = this.grammarInfo.getHeader() + "." + lexerName;
            parserPath = this.grammarInfo.getHeader() + "." + parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getHeader() + "." + this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        } else {
            lexerPath = lexerName;
            parserPath = parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        }
        classHeaderST.setAttribute("hasPackage", (Object)hasPackage);
        classHeaderST.setAttribute("packagePath", (Object)packagePath);
        classHeaderST.setAttribute("lexerPath", (Object)lexerPath);
        classHeaderST.setAttribute("parserPath", (Object)parserPath);
        classHeaderST.setAttribute("treeParserPath", (Object)treeParserPath);
        classHeaderST.setAttribute("isTreeGrammar", (Object)isTreeGrammar);
        return classHeaderST.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup group) {
        StringBuffer buf = new StringBuffer();
        if (this.grammarInfo.getTreeGrammarName() != null) {
            for (gUnitTestSuite ts : this.grammarInfo.getRuleTestSuites()) {
                int i = 0;
                for (gUnitTestInput input : ts.testSuites.keySet()) {
                    String outputString;
                    String inputString;
                    StringTemplate testRuleMethodST;
                    ++i;
                    if (ts.testSuites.get(input).getType() == 7 && this.ruleWithReturn.containsKey(ts.getTreeRuleName())) {
                        testRuleMethodST = group.getInstanceOf("testTreeRuleMethod2");
                        inputString = JUnitCodeGen.escapeForJava(input.testInput);
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i));
                        testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.getTreeRuleName() + '\"'));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.getTreeRuleName()));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        testRuleMethodST = group.getInstanceOf("testTreeRuleMethod");
                        inputString = JUnitCodeGen.escapeForJava(input.testInput);
                        outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i));
                        testRuleMethodST.setAttribute("testTreeRuleName", (Object)('\"' + ts.getTreeRuleName() + '\"'));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("tokenType", (Object)this.getTypeString(ts.testSuites.get(input).getType()));
                        if (ts.testSuites.get(input).getType() == 7) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else if (ts.testSuites.get(input).getType() == 10) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else {
                            testRuleMethodST.setAttribute("expecting", (Object)('\"' + JUnitCodeGen.escapeForJava(outputString) + '\"'));
                        }
                    }
                    buf.append(testRuleMethodST.toString());
                }
            }
        } else {
            for (gUnitTestSuite ts : this.grammarInfo.getRuleTestSuites()) {
                int i = 0;
                for (gUnitTestInput input : ts.testSuites.keySet()) {
                    StringTemplate testRuleMethodST;
                    ++i;
                    if (ts.testSuites.get(input).getType() == 7 && this.ruleWithReturn.containsKey(ts.getRuleName())) {
                        testRuleMethodST = group.getInstanceOf("testRuleMethod2");
                        String inputString = JUnitCodeGen.escapeForJava(input.testInput);
                        String outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(ts.getRuleName()) + i));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + ts.getRuleName() + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("returnType", (Object)this.ruleWithReturn.get(ts.getRuleName()));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("expecting", (Object)outputString);
                    } else {
                        String testRuleName = ts.isLexicalRule() ? ts.getLexicalRuleName() : ts.getRuleName();
                        testRuleMethodST = group.getInstanceOf("testRuleMethod");
                        String inputString = JUnitCodeGen.escapeForJava(input.testInput);
                        String outputString = ts.testSuites.get(input).getText();
                        testRuleMethodST.setAttribute("isLexicalRule", (Object)ts.isLexicalRule());
                        testRuleMethodST.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(testRuleName) + i));
                        testRuleMethodST.setAttribute("testRuleName", (Object)('\"' + testRuleName + '\"'));
                        testRuleMethodST.setAttribute("testInput", (Object)('\"' + inputString + '\"'));
                        testRuleMethodST.setAttribute("isFile", (Object)input.inputIsFile);
                        testRuleMethodST.setAttribute("tokenType", (Object)this.getTypeString(ts.testSuites.get(input).getType()));
                        if (ts.testSuites.get(input).getType() == 7) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else if (ts.testSuites.get(input).getType() == 10) {
                            testRuleMethodST.setAttribute("expecting", (Object)outputString);
                        } else {
                            testRuleMethodST.setAttribute("expecting", (Object)('\"' + JUnitCodeGen.escapeForJava(outputString) + '\"'));
                        }
                    }
                    buf.append(testRuleMethodST.toString());
                }
            }
        }
        return buf.toString();
    }

    public String getTypeString(int type) {
        String typeText;
        switch (type) {
            case 4: {
                typeText = "org.antlr.gunit.gUnitParser.OK";
                break;
            }
            case 5: {
                typeText = "org.antlr.gunit.gUnitParser.FAIL";
                break;
            }
            case 11: {
                typeText = "org.antlr.gunit.gUnitParser.STRING";
                break;
            }
            case 12: {
                typeText = "org.antlr.gunit.gUnitParser.ML_STRING";
                break;
            }
            case 10: {
                typeText = "org.antlr.gunit.gUnitParser.RETVAL";
                break;
            }
            case 13: {
                typeText = "org.antlr.gunit.gUnitParser.AST";
                break;
            }
            default: {
                typeText = "org.antlr.gunit.gUnitParser.EOF";
            }
        }
        return typeText;
    }

    protected void writeTestFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "can't write file", ioe);
        }
    }

    public static String escapeForJava(String inputString) {
        inputString = inputString.replace("\\", "\\\\");
        inputString = inputString.replace("\"", "\\\"");
        inputString = inputString.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\b", "\\b").replace("\f", "\\f");
        return inputString;
    }

    protected String changeFirstCapital(String ruleName) {
        String firstChar = String.valueOf(ruleName.charAt(0));
        return firstChar.toUpperCase() + ruleName.substring(1);
    }

    static {
        logger.addHandler(console);
    }
}

