/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr3;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.mojo.antlr3.AntlrHelper;
import org.antlr.mojo.antlr3.GrammarInfo;
import org.antlr.tool.BuildDependencyGenerator;
import org.antlr.tool.Grammar;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public abstract class Antlr3PluginMojo
extends AbstractMojo {
    protected Set includes = new HashSet();
    protected Set excludes = new HashSet();
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    private Tool tool;
    private int conversionTimeout;
    protected MavenProject project;

    abstract File getSourceDirectory();

    abstract File getOutputDirectory();

    abstract File getLibDirectory();

    abstract void addSourceRoot(File var1);

    public void execute() throws MojoExecutionException {
        File outputDir = this.getOutputDirectory();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        this.tool = new Tool();
        DFA.MAX_TIME_PER_DFA_CREATION = this.conversionTimeout;
        File libFile = this.getLibDirectory();
        if (libFile != null) {
            if (!libFile.exists()) {
                libFile.mkdirs();
            }
            this.tool.processArgs(new String[]{"-lib", libFile.getAbsolutePath()});
        }
        File srcDir = this.getSourceDirectory();
        try {
            this.processGrammarFiles(srcDir, outputDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
        if (this.project != null) {
            this.addSourceRoot(outputDir);
        }
    }

    private void processGrammarFiles(File sourceDirectory, File outputDirectory) throws TokenStreamException, RecognitionException, IOException, InclusionScanException {
        SuffixMapping mapping = new SuffixMapping("g", Collections.EMPTY_SET);
        Set includes = this.getIncludesPatterns();
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        Set grammarFiles = scan.getIncludedSources(sourceDirectory, null);
        if (grammarFiles.isEmpty()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No grammars to process");
            }
        } else {
            List grammars = this.loadGrammarDependencies(grammarFiles, sourceDirectory, outputDirectory);
            this.sortIntoBuildOrder(grammars);
            boolean built = false;
            Iterator i = grammars.iterator();
            while (i.hasNext()) {
                built |= this.processGrammarFile((GrammarInfo)i.next());
            }
            if (!built && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No grammars processed; generated files are up to date");
            }
        }
    }

    private void sortIntoBuildOrder(List grammars) {
        Collections.sort(grammars, new Comparator(){

            public int compare(Object o1, Object o2) {
                GrammarInfo a = (GrammarInfo)o1;
                GrammarInfo b = (GrammarInfo)o2;
                if (a.dependsOn(b)) {
                    return 1;
                }
                if (b.dependsOn(a)) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private List loadGrammarDependencies(Set grammarFiles, File sourceDirectory, File outputDirectory) throws TokenStreamException, RecognitionException, IOException {
        ArrayList<GrammarInfo> result = new ArrayList<GrammarInfo>();
        Iterator i = grammarFiles.iterator();
        while (i.hasNext()) {
            String grammarFileName = ((File)i.next()).getPath();
            String sourceSubdir = this.findSourceSubdir(sourceDirectory, grammarFileName);
            File outputSubdir = new File(outputDirectory, sourceSubdir);
            this.tool.setOutputDirectory(outputSubdir.getPath());
            BuildDependencyGenerator dep = new BuildDependencyGenerator(this.tool, grammarFileName);
            result.add(new GrammarInfo(dep, grammarFileName));
        }
        return result;
    }

    public Set getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.g");
        }
        return this.includes;
    }

    private boolean processGrammarFile(GrammarInfo grammarInfo) throws TokenStreamException, RecognitionException, IOException {
        List outputFiles = grammarInfo.getBuildDependency().getGeneratedFileList();
        if (AntlrHelper.buildRequired(grammarInfo.getGrammarFileName(), outputFiles)) {
            this.generate(grammarInfo.getGrammarFileName());
            return true;
        }
        return false;
    }

    private String findSourceSubdir(File sourceDirectory, String grammarFileName) {
        String srcPath = sourceDirectory.getPath();
        if (!grammarFileName.startsWith(srcPath)) {
            throw new IllegalArgumentException("expected " + grammarFileName + " to be prefixed with " + sourceDirectory);
        }
        File unprefixedGrammarFileName = new File(grammarFileName.substring(srcPath.length()));
        return unprefixedGrammarFileName.getParent();
    }

    private void generate(String grammarFileName) throws TokenStreamException, RecognitionException, IOException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Processing grammar " + grammarFileName));
        }
        boolean exceptionWhenWritingLexerFile = false;
        String lexerGrammarFileName = null;
        Grammar grammar = this.tool.getRootGrammar(grammarFileName);
        grammar.composite.assignTokenTypes();
        grammar.composite.defineGrammarSymbols();
        grammar.composite.createNFAs();
        this.processGrammar(grammar);
        String lexerGrammarStr = grammar.getLexerGrammar();
        if (grammar.type == 4 && lexerGrammarStr != null) {
            lexerGrammarFileName = grammar.getImplicitlyGeneratedLexerFileName();
            try {
                Writer w = this.tool.getOutputFile(grammar, lexerGrammarFileName);
                w.write(lexerGrammarStr);
                w.close();
            }
            catch (IOException e) {
                exceptionWhenWritingLexerFile = true;
                throw e;
            }
            StringReader sr = new StringReader(lexerGrammarStr);
            Grammar lexerGrammar = new Grammar();
            lexerGrammar.composite.watchNFAConversion = Tool.internalOption_watchNFAConversion;
            lexerGrammar.implicitLexer = true;
            lexerGrammar.setTool(this.tool);
            File lexerGrammarFullFile = new File(this.tool.getFileDirectory(lexerGrammarFileName), lexerGrammarFileName);
            lexerGrammar.setFileName(lexerGrammarFullFile.toString());
            lexerGrammar.importTokenVocabulary(grammar);
            lexerGrammar.parseAndBuildAST((Reader)sr);
            sr.close();
            lexerGrammar.composite.assignTokenTypes();
            lexerGrammar.composite.defineGrammarSymbols();
            lexerGrammar.composite.createNFAs();
            this.processGrammar(lexerGrammar);
        }
    }

    private void processGrammar(Grammar grammar) {
        String language = (String)grammar.getOption("language");
        if (language != null) {
            CodeGenerator generator = new CodeGenerator(this.tool, grammar, language);
            grammar.setCodeGenerator(generator);
            generator.setDebug(this.debug);
            generator.setProfile(this.profile);
            generator.setTrace(this.trace);
            generator.genRecognizer();
            List delegates = grammar.getDirectDelegates();
            for (int i = 0; delegates != null && i < delegates.size(); ++i) {
                Grammar delegate = (Grammar)delegates.get(i);
                if (delegate == grammar) continue;
                this.processGrammar(delegate);
            }
        }
    }
}

