/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JVar;
import java.util.Map;
import java.util.SortedMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.rest.spring.handler.RestMethodHandler;
import org.androidannotations.rest.spring.holder.RestHolder;

public abstract class AbstractRestMethodWithParameterHandler
extends RestMethodHandler {
    public AbstractRestMethodWithParameterHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        super(targetClass, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        this.validatorHelper.doesNotReturnPrimitive((ExecutableElement)element, validation);
        this.restSpringValidatorHelper.doesNotHaveDuplicateFieldAndPartName((ExecutableElement)element, validation);
        this.restSpringValidatorHelper.hasOneOrZeroBodyParameter((ExecutableElement)element, validation);
        this.restSpringValidatorHelper.doesNotMixRequestEntityAnnotations((ExecutableElement)element, validation);
    }

    @Override
    protected IJExpression getRequestEntity(ExecutableElement element, RestHolder holder, JBlock methodBody, SortedMap<String, JVar> params) {
        Map<String, String> parameters;
        JVar httpHeaders = this.restAnnotationHelper.declareHttpHeaders(element, holder, methodBody);
        JVar entitySentToServer = this.restAnnotationHelper.getEntitySentToServer(element, params);
        if (entitySentToServer == null && (parameters = this.restAnnotationHelper.extractFieldAndPartParameters(element)) != null) {
            AbstractJClass hashMapClass = this.getJClass("org.springframework.util.LinkedMultiValueMap").narrow(new Class[]{String.class, Object.class});
            entitySentToServer = methodBody.decl((AbstractJType)hashMapClass, "parameters", (IJExpression)JExpr._new((AbstractJClass)hashMapClass));
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                methodBody.add((IJStatement)entitySentToServer.invoke("add").arg((IJExpression)JExpr.lit((String)parameter.getKey())).arg((IJExpression)params.get(parameter.getValue())));
            }
        }
        return this.restAnnotationHelper.declareHttpEntity(methodBody, entitySentToServer, httpHeaders);
    }
}

