/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.androidannotations.api.sharedpreferences.SetXmlSerializer;

public abstract class SharedPreferencesCompat {
    private static final Method APPLY_METHOD = SharedPreferencesCompat.findMethod(SharedPreferences.Editor.class, "apply", new Class[0]);
    private static final Method GET_STRING_SET_METHOD = SharedPreferencesCompat.findMethod(SharedPreferences.class, "getStringSet", String.class, Set.class);
    private static final Method PUT_STRING_SET_METHOD = SharedPreferencesCompat.findMethod(SharedPreferences.Editor.class, "putStringSet", String.class, Set.class);

    private SharedPreferencesCompat() {
    }

    public static void apply(SharedPreferences.Editor editor) {
        try {
            SharedPreferencesCompat.invoke(APPLY_METHOD, editor, new Object[0]);
            return;
        }
        catch (NoSuchMethodException e) {
            editor.commit();
            return;
        }
    }

    public static Set<String> getStringSet(SharedPreferences preferences, String key, Set<String> defValues) {
        try {
            return (Set)SharedPreferencesCompat.invoke(GET_STRING_SET_METHOD, preferences, key, defValues);
        }
        catch (NoSuchMethodException e) {
            String serializedSet = preferences.getString(key, null);
            if (serializedSet == null) {
                return defValues;
            }
            return SetXmlSerializer.deserialize(serializedSet);
        }
    }

    public static void putStringSet(SharedPreferences.Editor editor, String key, Set<String> values) {
        try {
            SharedPreferencesCompat.invoke(PUT_STRING_SET_METHOD, editor, key, values);
        }
        catch (NoSuchMethodException e1) {
            editor.putString(key, SetXmlSerializer.serialize(values));
        }
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> T invoke(Method method, Object obj, Object ... args) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException();
        }
        try {
            return (T)method.invoke(obj, args);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new NoSuchMethodException(method.getName());
    }
}

