/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import java.util.ArrayList;
import java.util.List;
import org.altbeacon.bluetooth.Pdu;

public class BleAdvertisement {
    private static final String TAG = "BleAdvertisement";
    private List<Pdu> mPdus;
    private byte[] mBytes;

    public BleAdvertisement(byte[] bytes) {
        this.mBytes = bytes;
        this.mPdus = this.parsePdus();
    }

    private List<Pdu> parsePdus() {
        ArrayList<Pdu> pdus = new ArrayList<Pdu>();
        Pdu pdu = null;
        int index = 0;
        do {
            if ((pdu = Pdu.parse(this.mBytes, index)) == null) continue;
            index = index + pdu.getDeclaredLength() + 1;
            pdus.add(pdu);
        } while (pdu != null && index < this.mBytes.length);
        return pdus;
    }

    public List<Pdu> getPdus() {
        return this.mPdus;
    }
}

