/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import android.annotation.TargetApi;

public class Pdu {
    private static final String TAG = "Pdu";
    public static final byte MANUFACTURER_DATA_PDU_TYPE = -1;
    public static final byte GATT_SERVICE_UUID_PDU_TYPE = 22;
    private byte mType;
    private int mDeclaredLength;
    private int mStartIndex;
    private int mEndIndex;
    private byte[] mBytes;

    @TargetApi(value=9)
    public static Pdu parse(byte[] bytes, int startIndex) {
        int length;
        Pdu pdu = null;
        if (bytes.length - startIndex >= 2 && (length = bytes[startIndex]) > 0) {
            byte type = bytes[startIndex + 1];
            int firstIndex = startIndex + 2;
            if (firstIndex < bytes.length) {
                pdu = new Pdu();
                pdu.mEndIndex = startIndex + length;
                if (pdu.mEndIndex >= bytes.length) {
                    pdu.mEndIndex = bytes.length - 1;
                }
                pdu.mType = type;
                pdu.mDeclaredLength = length;
                pdu.mStartIndex = firstIndex;
                pdu.mBytes = bytes;
            }
        }
        return pdu;
    }

    public byte getType() {
        return this.mType;
    }

    public int getDeclaredLength() {
        return this.mDeclaredLength;
    }

    public int getActualLength() {
        return this.mEndIndex - this.mStartIndex + 1;
    }

    public int getStartIndex() {
        return this.mStartIndex;
    }

    public int getEndIndex() {
        return this.mEndIndex;
    }
}

