/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;

public class MonitorState {
    private static final String TAG = "MonitorState";
    public static long INSIDE_EXPIRATION_MILLIS = 10000L;
    private boolean inside = false;
    private long lastSeenTime = 0L;
    private Callback callback;

    public MonitorState(Callback c) {
        this.callback = c;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public boolean markInside() {
        this.lastSeenTime = System.currentTimeMillis();
        if (!this.inside) {
            this.inside = true;
            return true;
        }
        return false;
    }

    public boolean isNewlyOutside() {
        if (this.inside && this.lastSeenTime > 0L && System.currentTimeMillis() - this.lastSeenTime > INSIDE_EXPIRATION_MILLIS) {
            this.inside = false;
            LogManager.d(TAG, "We are newly outside the region because the lastSeenTime of %s was %s seconds ago, and that is over the expiration duration of %s", this.lastSeenTime, System.currentTimeMillis() - this.lastSeenTime, INSIDE_EXPIRATION_MILLIS);
            this.lastSeenTime = 0L;
            return true;
        }
        return false;
    }

    public boolean isInside() {
        return this.inside && !this.isNewlyOutside();
    }
}

