/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.content.Context;
import android.content.Intent;
import java.util.Collection;
import java.util.Set;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.RegionViewModel;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangingData;

public class IntentHandler {
    private static final String TAG = IntentHandler.class.getSimpleName();

    public void convertIntentsToCallbacks(Context context, Intent intent) {
        Set<Object> notifiers;
        MonitoringData monitoringData = null;
        RangingData rangingData = null;
        if (intent != null && intent.getExtras() != null) {
            if (intent.getExtras().getBundle("monitoringData") != null) {
                monitoringData = MonitoringData.fromBundle(intent.getExtras().getBundle("monitoringData"));
            }
            if (intent.getExtras().getBundle("rangingData") != null) {
                rangingData = RangingData.fromBundle(intent.getExtras().getBundle("rangingData"));
            }
        }
        if (rangingData != null) {
            LogManager.d(TAG, "got ranging data", new Object[0]);
            if (rangingData.getBeacons() == null) {
                LogManager.w(TAG, "Ranging data has a null beacons collection", new Object[0]);
            }
            notifiers = BeaconManager.getInstanceForApplication(context).getRangingNotifiers();
            Collection<Beacon> beacons = rangingData.getBeacons();
            if (notifiers != null) {
                for (RangeNotifier rangeNotifier : notifiers) {
                    rangeNotifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
                }
            } else {
                LogManager.d(TAG, "but ranging notifier is null, so we're dropping it.", new Object[0]);
            }
            RangeNotifier dataNotifier = BeaconManager.getInstanceForApplication(context).getDataRequestNotifier();
            if (dataNotifier != null) {
                dataNotifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
            }
            if (BeaconManager.getInstanceForApplication(context).isRegionViewModelInitialized(rangingData.getRegion())) {
                RegionViewModel regionViewModel = BeaconManager.getInstanceForApplication(context).getRegionViewModel(rangingData.getRegion());
                regionViewModel.getRangedBeacons().postValue(rangingData.getBeacons());
            }
        }
        if (monitoringData != null) {
            LogManager.d(TAG, "got monitoring data", new Object[0]);
            notifiers = BeaconManager.getInstanceForApplication(context).getMonitoringNotifiers();
            Region region = monitoringData.getRegion();
            Integer state = monitoringData.isInside() ? 1 : 0;
            if (notifiers != null) {
                for (MonitorNotifier monitorNotifier : notifiers) {
                    LogManager.d(TAG, "Calling monitoring notifier: %s", monitorNotifier);
                    monitorNotifier.didDetermineStateForRegion(state, region);
                    MonitoringStatus.getInstanceForApplication(context).updateLocalState(region, state);
                    if (monitoringData.isInside()) {
                        monitorNotifier.didEnterRegion(monitoringData.getRegion());
                        continue;
                    }
                    monitorNotifier.didExitRegion(monitoringData.getRegion());
                }
            }
            if (BeaconManager.getInstanceForApplication(context).isRegionViewModelInitialized(monitoringData.getRegion())) {
                RegionViewModel regionViewModel = BeaconManager.getInstanceForApplication(context).getRegionViewModel(monitoringData.getRegion());
                regionViewModel.getRegionState().postValue((Object)state);
            }
        }
    }
}

