/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.SystemClock;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collections;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RssiFilter;

public class RunningAverageRssiFilter
implements RssiFilter {
    private static final String TAG = "RunningAverageRssiFilter";
    public static final long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 20000L;
    private static long sampleExpirationMilliseconds = 20000L;
    private ArrayList<Measurement> mMeasurements = new ArrayList();

    @Override
    public void addMeasurement(Integer rssi) {
        Measurement measurement = new Measurement();
        measurement.rssi = rssi;
        measurement.timestamp = SystemClock.elapsedRealtime();
        this.mMeasurements.add(measurement);
    }

    @Override
    public boolean noMeasurementsAvailable() {
        return this.mMeasurements.size() == 0;
    }

    @Override
    public int getMeasurementCount() {
        return this.mMeasurements.size();
    }

    @Override
    public double calculateRssi() {
        this.refreshMeasurements();
        int size = this.mMeasurements.size();
        int startIndex = 0;
        int endIndex = size - 1;
        if (size > 2) {
            startIndex = size / 10 + 1;
            endIndex = size - size / 10 - 2;
        }
        double sum = 0.0;
        for (int i = startIndex; i <= endIndex; ++i) {
            sum += (double)this.mMeasurements.get((int)i).rssi.intValue();
        }
        double runningAverage = sum / (double)(endIndex - startIndex + 1);
        LogManager.d(TAG, "Running average mRssi based on %s measurements: %s", size, runningAverage);
        return runningAverage;
    }

    private synchronized void refreshMeasurements() {
        ArrayList<Measurement> newMeasurements = new ArrayList<Measurement>();
        for (Measurement measurement : this.mMeasurements) {
            if (SystemClock.elapsedRealtime() - measurement.timestamp >= sampleExpirationMilliseconds) continue;
            newMeasurements.add(measurement);
        }
        this.mMeasurements = newMeasurements;
        Collections.sort(this.mMeasurements);
    }

    public static void setSampleExpirationMilliseconds(long newSampleExpirationMilliseconds) {
        sampleExpirationMilliseconds = newSampleExpirationMilliseconds;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    static long getSampleExpirationMilliseconds() {
        return sampleExpirationMilliseconds;
    }

    private class Measurement
    implements Comparable<Measurement> {
        Integer rssi;
        long timestamp;

        private Measurement() {
        }

        @Override
        public int compareTo(Measurement arg0) {
            return this.rssi.compareTo(arg0.rssi);
        }
    }
}

