/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import org.altbeacon.beacon.IntentHandler;
import org.altbeacon.beacon.logging.LogManager;

public class BeaconLocalBroadcastProcessor {
    private static final String TAG = "BeaconLocalBroadcastProcessor";
    private static BeaconLocalBroadcastProcessor mInstance = null;
    public static final String RANGE_NOTIFICATION = "org.altbeacon.beacon.range_notification";
    public static final String MONITOR_NOTIFICATION = "org.altbeacon.beacon.monitor_notification";
    @NonNull
    private Context mContext;
    int registerCallCount = 0;

    public static synchronized BeaconLocalBroadcastProcessor getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new BeaconLocalBroadcastProcessor(context);
        }
        return mInstance;
    }

    private BeaconLocalBroadcastProcessor() {
    }

    private BeaconLocalBroadcastProcessor(Context context) {
        this.mContext = context;
    }

    public void register() {
        ++this.registerCallCount;
        LogManager.d(TAG, "Register calls: global=" + this.registerCallCount, new Object[0]);
        this.unregister();
    }

    public void unregister() {
        --this.registerCallCount;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.registerCallCount > 0) {
            new IntentHandler().convertIntentsToCallbacks(context, intent);
        }
    }
}

